#include "common.h"
#include "vt.h"
#include "bit.h"
#include "mem.h"
#include "task.h"
#include "lcd.h"
#include "event.h"
#include "lock.h"

extern volatile TSS *cur_task;

vt vt_table[MAXVT];
vt *cur_vt;

long vt_alloc;

void init_vt() { vt_alloc=0;}

vt *open_vt(int video_mode,int super)
{
	int i;
	static char busy=0;

	//Hacemos atmica la bsqueda de vt
	lock(&busy);

	if (cur_task->vt !=(vt *)0) {unlock(&busy); return (vt *)0;} // Ya hay un VT

	for (i=0; i<MAXVT; i++) {
		if (!bit_tst((char *)&vt_alloc,i)) break;
	}

	if (i==MAXVT) {unlock(&busy); return (vt *)0;}	// No quedan VT's

	vt_table[i].video_mode=video_mode;
	vt_table[i].cursor_st=1;	// Cursor_on
	vt_table[i].p_x=0;
	vt_table[i].p_y=0;		// Posicin del cursor

        if (super) {
            vt_table[i].screen_base=kmalloc(S_RAM,3200<<video_mode);
        }else{
            vt_table[i].screen_base=kmalloc(U_RAM,3200<<video_mode);
        }
	if (vt_table[i].screen_base==(unsigned char *)0) {
		unlock(&busy);
		return (vt *)0;
	}
	vt_table[i].event=(fifo *)kmalloc(S_RAM,sizeof(fifo));
	if(vt_table[i].event==(fifo *)0) {
		kfree(vt_table[i].screen_base,3200<<video_mode);
		unlock(&busy);
		return (vt *)0;
	}

	bit_set((char *)&vt_alloc,i);		// Entrada ocupada
	fifo_flush(vt_table[i].event);
	cur_task->vt=&vt_table[i];

	unlock(&busy);
	return &vt_table[i];
}

void close_vt(vt *pvt)
{
	int ix;
	ix=((int)pvt-(int)vt_table)/sizeof(vt);
	if (!bit_tst((char *)&vt_alloc,ix)) return;
	kfree(pvt->screen_base, 3200<<pvt->video_mode);
	kfree((char *)pvt->event,sizeof(fifo));
	bit_clr((char *)&vt_alloc,ix);
}

void switch_vt(vt *pvt)
{
	int ix;
	ix=((int)pvt-(int)vt_table)/sizeof(vt);
	if (!bit_tst((char *)&vt_alloc,ix)) return;
	cur_vt=pvt;
        set_screen_base(cur_vt->screen_base);
	set_video_mode(cur_vt->video_mode);
	if (cur_vt->cursor_st) {
		set_cursor(cur_vt);
	} else cursor_off(cur_vt);
}

void close_my_vt()
{
	if (cur_task->vt==cur_vt) {
		switch_vt(vt_table);
		fifo_put(EV_FOCUS_ON,cur_vt->event);
	}
	close_vt(cur_task->vt);
	cur_task->vt=(vt *)0;
}

