#include "flash.h"
short vector_touch;
extern int trap_table;


void init_vector() {
	unsigned int *pa,*pb;
	unsigned short *psa;
	int i;
	
	pa=&trap_table;
	pb=(unsigned int *)0;
	vector_touch=0;
	
	//Comprobamos vectores
	for (i=0;i<0x50;i++) if (*pa++!=*pb++) break;

	if (i==0x50) return;

#ifdef DV2MB
	vector_touch=1;
	//Borramos el primer sector de la flash
	flash_erase_block(0);
	// Programamos la tabla de vectores en flash
	psa=(unsigned short *)&trap_table;
	for (i=0;i<160;i++) {
		flash_prg_w(i<<1,*psa++);
	}
#else
	memcpy((char *)0,(char *)&trap_table,320);
#endif
}
