#include <stdarg.h>

#include "../syscall.h"
#include "ulib.h"

#define FILL 1
#define FILL0 2
#define SIGNED 4

int __errno;

int syscall(int cix,...)
{
	asm volatile ("trap #0");
}

void putchar(char a)
{
	syscall(PUTCHAR,a); 
}

void puts(char *a)
{
	while (*a) putchar(*a++);
}

void sputch(char a,char **p)
{
	*(*p)++=a;
}

void prtn(void (*putch)(char,char **),char **pc, int dato, short base, short nd, short flags)
{
	static const char digit[16]={	'0','1','2','3','4','5','6','7',
				'8','9','A','B','C','D','E','F'};
	char buf[34],*p;
	short i,r,neg;
	unsigned int d;
	
	if (base>16 || base<2) return;
	
	if (dato<0 && (flags&SIGNED)) {neg=1; d=-dato; nd--;}
	else {neg=0; d=dato;}
	
	i=0; p=buf;
	do {
		r=d%base; d/=base;
		*p++=digit[r];
		i++;
	} while (d);

	if (flags&FILL) {
		if (flags&FILL0){
			for (;i<nd;i++) *p++='0';
			if (neg) *p++='-';
		}else {
			if (neg) *p++='-';
			for (;i<nd;i++) *p++=' ';
		}
	}else if (neg) *p++='-';
	
	while (p>buf) putch(*--p,pc); 
}

void prtf(void (*putch)(char,char **),char **pc,double dato,short nd)
{
	int i,j,ex,f;
	
	f=nd;
	ex=0;
	if (dato<0) {
		putch('-',pc);
		dato=-dato;
		nd--;
	}
	if (dato==0) { putch('0',pc); return; }
	if (dato>=1e6) {
	    do {
		dato/=10;
		ex++;
	    } while (dato>=10);
	} else if(dato<1e-3) {
	    do {
		dato*=10;
		ex--;
	    } while (dato<1);
	}
	
	//Mantisa
	//Vemos el espacio que queda para mantisa
	i=ex;
	if (i!=0) nd-=2;
	if (i<0) {nd--; i=-i;}
	if (i>=10) nd--;
	if (i>100) nd--;
	
	dato+=1e-15;	// Para evitar 0.9999999's

	i=dato;
	dato-=i;
	prtn(putch,pc,i,10,0,0);
	nd--;
	while (i/=10) nd--;

	if (dato!=0) {
	    putch('.',pc); nd--;
	    if (nd<=0) nd=1;
	    if (!f) nd=8;
	    for (i=0;i<nd;i++) {
	    	if (!f && (dato<1e-8)) break; // evitar 0's a derecha
		dato*=10;
		j=dato;
		dato-=j;
		putch('0'+j,pc);
	    }
	}
	
	//exponente
	if (ex!=0) {
	    putch('e',pc);
	    if (ex<0) { putch('-',pc); ex=-ex;}
	    prtn(putch,pc,ex,10,0,0);
	}	
}


/**------------------------------------------------------------------------**/

void core_printf(void (*putch)(char,char **),char **pc,int *ppar)
{
	short fl,base,nd,cont;
	char *fmt,*p;
	int n;
	
	fmt=(char *)*ppar; ppar++;
	
	while (*fmt){
		if (*fmt=='%'){
			fl=0;
			nd=0;
			fmt++;
			cont=0;
			do {
				switch(*fmt++) {
				case 'd':	fl|=SIGNED;
				case 'u':	base=10;
						n=*ppar++;
						prtn(putch,pc,n,base,nd,fl);
						cont=0;
						break;
				case 'x':
				case 'X':	base=16;
						n=*ppar++;
						prtn(putch,pc,n,base,nd,fl);
						cont=0;
						break;
				case 'b':	base=2;
						n=*ppar++;
						prtn(putch,pc,n,base,nd,fl);
						cont=0;
						break;
				case 'c':	n=*ppar++;
						putch(n,pc);
						cont=0;
						break;
				case 's':	p=(char *)*ppar++;
						while(*p) putch(*p++,pc);
						cont=0;
						break;
				case '%':	putch('%',pc);
						cont=0;
						break;
				case 'g':
				case 'f':	prtf(putch,pc,*((double*)ppar),nd);
						ppar=(int *)((int)ppar+sizeof(double));
						cont=0;
						break;
				case '0':	if (!cont) fl|=FILL0;
						nd*=10; fl|=FILL;
						cont=1;	break;
				case '1':	nd*=10;nd+=1;
						cont=1; fl|=FILL; break;
				case '2':	nd*=10;nd+=2;
						cont=1; fl|=FILL; break;
				case '3':	nd*=10;nd+=3;
						cont=1; fl|=FILL; break;
				case '4':	nd*=10;nd+=4;
						cont=1; fl|=FILL; break;
				case '5':	nd*=10;nd+=5;
						cont=1; fl|=FILL; break;
				case '6':	nd*=10;nd+=6;
						cont=1; fl|=FILL; break;
				case '7':	nd*=10;nd+=7;
						cont=1; fl|=FILL; break;
				case '8':	nd*=10;nd+=8;
						cont=1; fl|=FILL; break;
				case '9':	nd*=10;nd+=9;
						cont=1; fl|=FILL; break;
				}
			} while (cont);
		}else putch(*fmt++,pc);
	}

}

void gen_printf(int ch,char *fmt,...)
{
	switch(ch) {
	case 0:	core_printf((void (*)(char,char **))putchar,(char **)0,(int *)&fmt);
	}
}

void printf(char *fmt,...)
{
	core_printf((void (*)(char,char **))putchar,(char **)0,(int *)&fmt);
}

void sprintf(char *buf,char *fmt,...)
{
	core_printf(sputch,&buf,(int *)&fmt);
	*buf=0; // terminador
}

/***************************************************************************/

double atof(char *p)
{
	char a;
	int sgm=1,sge=1,fex=0,fp=0,ex;
	double vm,vf;
	
	while (*p==' ') p++;
	if (*p=='+') p++;
	if (*p=='-') {p++; sgm=-1;}
	
	vm=0; ex=0; vf=0.1;
	for (;;){
		a=*p++;
		if (a>='0' && a<='9') {
			a-='0';
			if (fex) {
				ex=ex*10+a;
			} else {
				if (fp) {
					vm+=a*vf;
					vf*=0.1;
				} else	vm=vm*10+a;
			}
			continue;
		}
		if (a=='-') {
			if (fex && (sge==1)) {sge=-1; continue;}
			else break;
		}
		if (a=='.') { fp=1; continue;}
		if (a=='e' || a=='E') { fex=1; continue; }
		break;
	}
	vm*=sgm; ex*=sge;
	if (ex>0) { for (;ex;ex--) vm*= 10; return vm;}
	if (ex<0) { for (;ex;ex++) vm*=0.1; return vm;}
	return vm;
}
