#include "common.h"
#include "task.h"
#include "fifo.h"
#include "event.h"
#include "lowio.h"
#include "panic.h"

const char *const trap_name[]={
"","","BUS ERROR","ODD ADDR.","ILLEGAL","DIVIDE by 0","CHK OUT of RANGE",
"TRAP on OVERFLOW","PRIVILEGE VIOLATION","TRACE EXECUTION",
"A-LINE EMULATION","F-LINE EMULATION"
};

typedef struct {
	unsigned int	d[8];
	unsigned int	a[7];
	unsigned short	ir1;
	unsigned int	dir;
	unsigned short	ir2;
	unsigned short	sr;
	unsigned int 	pc;
} stl;

typedef struct {
	unsigned int	d[8];
	unsigned int	a[7];
	unsigned short	sr;
	unsigned int 	pc;
} sts;

typedef union {
	stl l;
	sts s;
} stack_trace;

extern fifo ffevent;
extern TSS *cur_task;

void do_trap(unsigned int vector,stack_trace *sp)
{
	short i;
	unsigned int j,k;

	if (vector<=3) {i=sp->l.sr; j=sp->l.pc;}
	else {i=sp->s.sr; j=sp->s.pc;}

	if (!(i&0x2000)) {
		/**** Modo usuario: matar tarea y avisar ****/
		fifo_put(0x80+vector,&ffevent);
		k=(int)cur_task;
		fifo_put((k>>24)&0xff,&ffevent); //tarea
		fifo_put((k>>16)&0xff,&ffevent);
		fifo_put((k>>8)&0xff,&ffevent);
		fifo_put(k&0xff,&ffevent);
		fifo_put((j>>24)&0xff,&ffevent); //PC
		fifo_put((j>>16)&0xff,&ffevent);
		fifo_put((j>>8)&0xff,&ffevent);
		fifo_put(j&0xff,&ffevent);

		task_exit();
		for(;;);	// Por si acaso
	}

	/******* Modo supervisor: PANIC *******/

        panic((char *)0);

	if (vector>0xb) {
            panic_puts("Trap vector: 0x");
            panic_prhex(vector,2);
            panic_putch('\n');
        }
	else {
		panic_puts(trap_name[vector]); panic_putch('\n');
		if (vector<=3) {
                    panic_puts("\nDIR=");
                    panic_prhex(sp->l.dir,8);
                }
                panic_putch('\n');
	}

	asm volatile("move.l %%usp,%0" : "=a" (j));
        panic_puts("\nUSP="); panic_prhex(j,8); panic_putch('\n');
        panic_puts("SP ="); panic_prhex((unsigned int)sp,8); panic_putch('\n');

	if (vector<=3) {
           panic_puts("PC ="); panic_prhex(sp->l.pc,8); panic_putch('\n');
           panic_puts("SR ="); panic_prhex(sp->l.sr,4); panic_putch('\n');
        } else {
           panic_puts("PC ="); panic_prhex(sp->s.pc,8); panic_putch('\n');
           panic_puts("SR ="); panic_prhex(sp->s.pc,4); panic_putch('\n');
        }

        panic_puts("\n  D0-D7\t  A0-A7\n");
	for (i=0;i<7;i++) {
                panic_prhex(sp->s.d[i],8); panic_putch(' ');
                panic_prhex(sp->s.a[i],8); panic_putch('\n');
	}

        panic_prhex(sp->s.d[7],8); panic_putch(' ');
        panic_prhex((unsigned int)sp,8); panic_putch('\n');

        // Paramos el reloj de la CPU y no retornamos
        for(;;) {asm volatile (" move.b  #0x80,0xfffff207");}
}
