#include "time.h"
#include "lang.h"

const unsigned char month_len[12]={
   31,28,31,    // enero, febrero, marzo
   30,31,30,    // abril, nayo, junio
   31,31,30,    // julio, agosto, septiembre
   31,30,31     // octubre, noviembre, diciembre
};
const char * const month_names[12]={ LST_TIME_MONTH };

extern unsigned short year,alyear;

void get_time(time *t, int timer)
{
        int i,j,y,dcnt;

        if (timer==TIME_RTC) {
            t->hour=(*(volatile unsigned char *)0xfffffb00)&0x1f;
            t->min=(*(volatile unsigned char *)0xfffffb01)&0x3f;
            t->sec=(*(volatile unsigned char *)0xfffffb03)&0x3f;
            dcnt=(*(volatile unsigned short *)0xfffffb1a)&0x1ff;
            y=year;
        } else if (timer==TIME_ALARM){
            t->hour=(*(volatile unsigned char *)0xfffffb04)&0x1f;
            t->min=(*(volatile unsigned char *)0xfffffb05)&0x3f;
            t->sec=(*(volatile unsigned char *)0xfffffb07)&0x3f;
            dcnt=(*(volatile unsigned short *)0xfffffb1c)&0x1ff;
            y=alyear;
        }

        for (i=0;i<12;i++) {
            if(i==1) {
                j=(y&3)?28:29;
            } else j=month_len[i];

            if(dcnt<j) break;
            dcnt-=j;
        }
        i++;
        if (i>12) i=12;

        t->day=dcnt+1;
        t->month=i;
        t->year=y;
}

void set_time(time *t, int timer)
{
        int i,j,dcnt;

        dcnt=t->day-1;
        for (i=0;i<t->month-1;i++) {
            if(i==1) {
                j=((t->year)&3)?28:29;
            } else j=month_len[i];
            dcnt+=j;
        }

        if (timer==TIME_RTC) {
            *(volatile unsigned char *)0xfffffb00=t->hour;
            *(volatile unsigned char *)0xfffffb01=t->min;
            *(volatile unsigned char *)0xfffffb03=t->sec;
            *(volatile unsigned short *)0xfffffb1a=dcnt;
            year=t->year;
        } else if (timer==TIME_ALARM){
            *(volatile unsigned char *)0xfffffb04=t->hour;
            *(volatile unsigned char *)0xfffffb05=t->min;
            *(volatile unsigned char *)0xfffffb07=t->sec;
            *(volatile unsigned short *)0xfffffb1c=dcnt;
            alyear=t->year;
        }
}

int time_day()
{
        int i,dcnt;
        dcnt=(*(volatile unsigned short *)0xfffffb1a)&0x1ff;
        i=(year&3)?365:366;
        if (dcnt==i) {
                year++; *(volatile unsigned short *)0xfffffb1a=0;
                return 1;
        }
        return 0;
}
