#include "common.h"
#include "vt.h"
#include "task.h"
#include "mem.h"
#include "event.h"
#include "fifo.h"
#include "lock.h"
#include "audio.h"

extern vt vt_table[], *cur_vt;

TSS task_table[MAXTASK];
TSS *cur_task;
short ntask;

short task_start(void *pc,short sr,int stack_size,short priority,char *name)
{
	task_stack *pts;
	short i;
	char *p,*up;
	static char busy=0;	//Semforo

	lock(&busy);
	
	stack_size&=0xfffffffe;	//Tamao par.

	/*** Buscamos primero en tareas KILLED ***/
	for (i=0;i<ntask;i++) {
		if(task_table[i].status == KILLED) break;
	}
	
	if (i<MAXTASK){
	    if( sr & 0x2000 ) {
	    	// Modo supervisor
	    	p=tmalloc(S_RAM,i,stack_size+512);
	    	if (p==(char*)0) {unlock(&busy); return -1;}
	    	task_table[i].sp=((unsigned int)p)+stack_size+512;
	    } else {
	    	// Modo usuario
	    	p=tmalloc(S_RAM,i,512);
	    	if (p==(char*)0) {unlock(&busy); return -1;}
	    	task_table[i].sp=((unsigned int)p)+512;
	    	up=tmalloc(U_RAM,i,stack_size);
	    	if (up==(char*)0) {
	    		kfree(p,512);
	    		unlock(&busy); return -1;
	    	}
	    	
	    }
	    task_table[i].sp-=sizeof(task_stack);
	    task_table[i].name=name;
	    task_table[i].vt=(vt *)0;
	    task_table[i].priority=priority;
	    task_table[i].clks=0;
	    task_table[i].pcount=priority;
	    pts=(task_stack *)task_table[i].sp;
	    pts->pc=(unsigned int)pc;
	    pts->sr=sr;
	    if (!(sr & 0x2000)) pts->usp=((unsigned int)up)+stack_size;
	    task_table[i].status=RUNNING;
	    if (i==ntask) ntask++;
	    
	} else i=-1;	/* Si no quedan entradas retornamos error */

	unlock(&busy);
	return i;
}

extern void shell();
extern void eventd();

int ev_pid;

void init_task()
{
	ntask=1;
	cur_task=task_table;
	
	//Preparamos tarea 0 (IDLE)
	
	task_table[0].priority=0;
	task_table[0].pcount=0;
	task_table[0].status=RUNNING;
	task_table[0].name="idle";
	task_table[0].clks=0;
	
	// Arrancamos tarea 1 (shell)
	task_start(shell,0x2000,512,100,"shell");
	// Y tarea 2 (eventd)
	ev_pid=task_start(eventd,0x2000,512,100,"eventd");
}

void task_sleep(short delay) {
	if(delay) cur_task->status=delay;
	else cur_task->status=SLEEPED;
	asm volatile("trap #1");
}

extern TSS *audio_task;
extern TSS *pwm_task;

void task_kill(short tix)
{
	if (tix<2) return;
	if (task_table[tix].vt) {
		if (task_table[tix].vt==cur_vt) {
			switch_vt(vt_table);
			fifo_put(EV_FOCUS_ON,cur_vt->event);
		}
		close_vt(task_table[tix].vt);
	}
	if (&task_table[tix]==audio_task) audio_stop();
	if (&task_table[tix]==pwm_task) pwm_stop();
	free_task_mem(tix);
	task_table[tix].status=KILLED;
	asm volatile("trap #1");
}

void task_exit()
{
	int tix;
	tix=((unsigned int)cur_task - (unsigned int)task_table)/sizeof(TSS);
	task_kill(tix);
}

/********** Rutinas llamadas desde interrupciones/traps **********/

unsigned int ticcnt;

void level_6_irq()
{
	short i;
	ticcnt++;
	//Actualizamos temporizadores de tareas
	for (i=0;i<ntask;i++) 
		if (task_table[i].status>0) task_table[i].status--;
}

unsigned long long system_clks=0;

TSS *schedule()
{
	unsigned short i,j,c;
	static unsigned short tstamp=0;
	TSS *pts;
	
	// Buscamos el mximo pcount de las tareas "RUNNING"
	// Y actualizamos pcount's para la siguiente vez

	//Actualizamos el tiempo de CPU de la tarea actual, que va a conmutar
	i=*(unsigned short *)0xfffff608;
	j=(i-tstamp); tstamp=i;
	cur_task->clks+=j;
	system_clks+=j;
	
	for(i=j=c=0;i<ntask;i++) {
		if (task_table[i].status==RUNNING) {
			if (task_table[i].pcount>j) {
				j=task_table[i].pcount;
				c=i;
			}
			task_table[i].pcount+=task_table[i].priority;
		}
	}
	
	task_table[c].pcount=task_table[c].priority;

	pts=&task_table[c];
	return pts;
}
