/* Caracteres especiales del protocolo SLIP */
#define FEND	0xC0 
#define FESC	0xDB
#define TFEND	0xDC
#define TFESC	0xDD

#define MAXLEN	256
#define NBUF	4

/* Estados de la mquina slip */

enum {			// Estado del receptor
	RX_WFEND,	// Esperando FEND
	RX_WDATA,	// Esperando datos
	RX_RDATA,	// Recibiendo datos
	RX_FESC		// Recibiendo caracteres escapados
};

enum {			// Estado del transmisor
	TX_IDLE,	// Nada que transmitir
	TX_FEND,	// Transmitiendo FEND
	TX_DATA,	// Transmitiendo datos
	TX_TFEND,	// Transmitiendo TFEND
	TX_TFESC,	// Transmitiendo TFESC
	TX_FEND1	// Transmitiendo FEND de final de paquete
};

typedef struct {
	char *data;
	int len;
} slip_pkt;

void slip_init();
char *pkt_alloc();
void pkt_free(char *p);
void rx_q_get(slip_pkt *pkt);
void tx_q_put(char *data, int len);
