#include "common.h"
#include "slip.h"
#include "task.h"
#include "panic.h"

extern TSS *cur_task;

char pkt_mem[NBUF*MAXLEN];

slip_pkt rx_q[NBUF];
volatile slip_pkt *rx_wp;
volatile slip_pkt *rx_rp;
volatile TSS *rx_blk_task;

slip_pkt tx_q[NBUF];
volatile slip_pkt *tx_wp;
volatile slip_pkt *tx_rp;
volatile TSS *tx_blk_task;

slip_pkt pkt_pool[NBUF];

volatile short int txst;
volatile short int rxst;

unsigned int slip_ndrop,slip_nrx,slip_ntx;

/*******************************************************************/

void slip_init()
{
	int i;
	char *p;

	// Prepara pkt_alloc
	p=pkt_mem;
	for (i=0;i<NBUF;i++) {
		pkt_pool[i].data=p;
		pkt_pool[i].len=0;
		p=(char *)((int)p+MAXLEN);
	}

	// Colas vacas
	rx_wp=rx_rp=rx_q;
	tx_wp=tx_rp=tx_q;
	tx_blk_task=rx_blk_task=(TSS *)0;

	// Mquinas de estados desocupadas
	rxst=RX_WFEND;
	txst=TX_IDLE;

	// Estadsticas a cero
	slip_ndrop=slip_nrx=slip_ntx=0;

	// Inicializa UART

	asm volatile("
	lea.l	0xfffff000,%a0
	move.w  #0xe100,0x900(%a0)	|Control: UART enable, 8 bits
	move.b  #0xe8,0x906(%a0)        |Ignore CTS
	move.w  #0x0,0x908(%a0)		|Control II (defecto)
	move.w  #0x38,0x902(%a0)        |Baud=115200
	move.w	0x904(%a0),%d0		|Limpiamos FIFO Rx
	move.w	#0xe190,0x900(%a0)	|Habilita Old DATA y RX Half FIFO INTS
	bclr.b	#2,0x307(%a0)		|Habilita INT UART
	");

}

/**************** Asignacin de buffers ***************/

char *pkt_alloc()
{
	int i;
        unsigned short flg;

        asm volatile ("move.w %%sr,%0 \n  move.w #0x2700,%%sr":"=d"(flg):);

	for(i=0;i<NBUF;i++) {
		if (pkt_pool[i].len==0) {
			pkt_pool[i].len=1;
                        asm volatile ("move.w %0,%%sr"::"d"(flg));
			return pkt_pool[i].data;
		}
	}

        asm volatile ("move.w %0,%%sr"::"d"(flg));
	return (char *)0;
}

void pkt_free(char *p)
{
	int i;
        unsigned short flg;

        asm volatile ("move.w %%sr,%0 \n  move.w #0x2700,%%sr":"=d"(flg):);

	for(i=0;i<NBUF;i++) {
		if (pkt_pool[i].data==p) {
			pkt_pool[i].len=0;
                        asm volatile ("move.w %0,%%sr"::"d"(flg));
			return;
		}
	}

        asm volatile ("move.w %0,%%sr"::"d"(flg));
}

/****************** COLA TX ********************/

void tx_q_put(char *data, int len) {
	slip_pkt *pk;
	pk=(slip_pkt *)tx_wp; pk++; if (pk==&tx_q[NBUF]) pk=tx_q;
	while (pk==tx_rp) {
		tx_blk_task=cur_task;
		task_sleep(0);
	}
	tx_wp->data=data; tx_wp->len=len;
	tx_wp=pk;
	if (txst==TX_IDLE) {
		txst=TX_FEND;
		asm volatile ("bset.b #2,0xfffff901");	// INT en cola TX vaca
	}
}

void tx_q_get(slip_pkt *psk)
{
	if (tx_rp==tx_wp) { psk->len=0; return;}
	psk->data=tx_rp->data; psk->len=tx_rp->len;
	tx_rp++; if(tx_rp==&tx_q[NBUF]) tx_rp=tx_q;
	if (tx_blk_task) {
		tx_blk_task->status=RUNNING;
		tx_blk_task=(TSS *)0;
	}
}

/********************* COLA RX *******************/

void rx_q_get(slip_pkt *psk)
{
	while (rx_rp==rx_wp) {
		rx_blk_task=cur_task;
		task_sleep(0);
	}
	psk->data=rx_rp->data; psk->len=rx_rp->len;
	rx_rp++; if(rx_rp==&rx_q[NBUF]) rx_rp=rx_q;
}

void rx_q_put(char *data, int len)
{
	slip_pkt *pk;
	pk=(slip_pkt *)rx_wp; pk++; if (pk==&rx_q[NBUF]) pk=rx_q;
	if (pk==rx_rp) { slip_ndrop++; return;}
	rx_wp->data=data; rx_wp->len=len;
	rx_wp=pk;
	if(rx_blk_task) {
		rx_blk_task->status=RUNNING;
		rx_blk_task=(TSS *)0;
	}
}

/************************************************************************/
/*									*/
/*			MQUINA de ESTADOS SLIP				*/
/*									*/
/************************************************************************/

void uart_irq()
{
        static slip_pkt rxp,txp;
        static char *pr,*pw;
        unsigned char a,rxflg=0;


	/*------------------- RECEPCIN -------------------*/
        if ((*(volatile unsigned char *)0xfffff904)&8)
               panic("PANIC:\nUART RX OVERRUN");

	while ((*(volatile unsigned char *)0xfffff904)&0x20) {
            rxflg=1;
	    a=*(volatile unsigned char *)0xfffff905;
	    switch(rxst) {
	    case RX_WFEND:
	    	if (a==FEND) rxst=RX_WDATA;
	    	break;
	    case RX_WDATA:
	    	if (a==FEND) break;
	    	if ((pw=pkt_alloc())==(char *)0) {
	    	    	rxst=RX_WFEND;
	    	    	slip_ndrop++;
	    	    	break;
	    	}
	    	rxp.data=pw; rxp.len=0;
	    	rxst=RX_RDATA;
	    case RX_RDATA:
	    	if (a==FEND) {
	    		rx_q_put(rxp.data,rxp.len);
	    		slip_nrx++;
	    		rxst=RX_WDATA;
	    		break;
	    	}
	    	if (a==FESC) {rxst=RX_FESC; break;}
	    	*pw++=a; rxp.len++;
	    	if (rxp.len>MAXLEN) {
	    		rxst=RX_WFEND;
	    		pkt_free(rxp.data);
	    		slip_ndrop++;
	    	}
	    	break;
	    case RX_FESC:
	    	if (a==TFEND) a=FEND;
	    	else if (a==TFESC) a=FESC;
	    	else {
	    		rxst=RX_WFEND;
	    		pkt_free(rxp.data);
	    		slip_ndrop++;
	    		break;
	    	}
	  	*pw++=a; rxp.len++;
    	    	if (rxp.len>MAXLEN) {
    	    		rxst=RX_WFEND;
    	    		pkt_free(rxp.data);
    	    		slip_ndrop++;
    	    		break;
    	    	}
	  	rxst=RX_RDATA;
	  	break;
	    }
	}

        if (rxflg) return;
	/*------------------ TRANSMISIN --------------------*/

	if (txst) {
            while((*(volatile unsigned char *)0xfffff906)&0x20) {
	    	switch(txst) {
	    	case TX_FEND:
	    		tx_q_get(&txp);
	    		if(!txp.len) {
	    			txst=TX_IDLE;
	    			asm volatile("bclr.b #2,0xfffff901");
	    			return;
	    		}
	    		*(volatile unsigned char *)0xfffff907=FEND;
	    		pr=txp.data;
	    		txst=TX_DATA;
	    		break;
	    	case TX_DATA:
	    		a=*pr++; txp.len--;
	    		if (a==FEND) {
	    			*(volatile unsigned char *)0xfffff907=FESC;
	    			txst=TX_TFEND;
	    			break;
	    		}
	    		if (a==FESC) {
	    			*(volatile unsigned char *)0xfffff907=FESC;
	    			txst=TX_TFESC;
	    			break;
	    		}
	    		*(volatile unsigned char *)0xfffff907=a;
	    		if (!txp.len) txst=TX_FEND1;
	    		break;
	    	case TX_TFEND:
	    		*(volatile unsigned char *)0xfffff907=TFEND;
	    		if (!txp.len) txst=TX_FEND1;
	    		else txst=TX_DATA;
	    		break;
	    	case TX_TFESC:
	    		*(volatile unsigned char *)0xfffff907=TFESC;
	    		if (!txp.len) txst=TX_FEND1;
	    		else txst=TX_DATA;
	    		break;
	    	case TX_FEND1:
	    		*(volatile unsigned char *)0xfffff907=FEND;
	    		pkt_free(txp.data);
	    		slip_ntx++;
	    		txst=TX_FEND;
	    		break;
	    	}
            }
	}
}
