#include "common.h"
#include "task.h"
#include "fifo.h"
#include "event.h"
#include "lowio.h"
#include "klib.h"
#include "mem.h"
#include "pen.h"
#include "vt.h"
#include "keyboard.h"
#include "lcd.h"
#include "file.h"
#include "flash.h"
#include "file_action.h"
#include "slip.h"
#include "audio.h"
#include "time.h"
#include "lang.h"
#include "version.h"

extern void eventd();
extern void test_lissa();
extern void test_4bpp();
extern void test_2bpp();

extern TSS task_table[];
extern short ntask;
extern vt vt_table[];
extern unsigned char u_ram_map[];
extern unsigned char s_ram_map[];

extern short calibrando;

void gettapxy(vt *pvt,int *x, int *y)
{
	int ev;
	cursor_off(pvt);
	do {
		ev=fifo_get(pvt->event);
		switch(ev) {
			case EV_KEYBOARD:
				//kputchar(fifo_get(pvt->event));
				fifo_get(pvt->event);
				break;
			case EV_LCD_TAP_PRESS:
				*x=fifo_get(pvt->event);
				*y=fifo_get(pvt->event);
				break;
			case EV_LCD_TAP_REL:
				break;
			case EV_FOCUS_ON:
				break;
			case EV_FOCUS_OFF:
				break;
		}
	}while (ev!=EV_LCD_TAP_PRESS);
}

int getkey(vt *pvt)
{
	int ev,k;
	do {
		ev=fifo_get(pvt->event);
		switch(ev) {
			case EV_KEYBOARD:
				//kputchar(fifo_get(pvt->event));
				k=fifo_get(pvt->event);
				break;
			case EV_LCD_TAP_PRESS:
				fifo_get(pvt->event);
				fifo_get(pvt->event);
				break;
			case EV_LCD_TAP_REL:
				break;
			case EV_FOCUS_ON:
				break;
			case EV_FOCUS_OFF:
				break;
		}
	}while (ev!=EV_KEYBOARD);
        return k;
}

void gettapxynb(vt *pvt,int *x, int *y)
{
	int ev;
	cursor_off(pvt);
	*y=-1;
	ev=fifo_getnb(pvt->event);
	switch(ev) {
		case EV_KEYBOARD:
			//kputchar(fifo_get(pvt->event));
			fifo_get(pvt->event);
			break;
		case EV_LCD_TAP_PRESS:
			*x=fifo_get(pvt->event);
			*y=fifo_get(pvt->event);
			break;
		case EV_LCD_TAP_REL:
			break;
		case EV_FOCUS_ON:
			break;
		case EV_FOCUS_OFF:
			break;
	}
}

int gettap(vt *pvt)
{
	int x,y;
	gettapxy(pvt,&x,&y);
	return y>>3;
}

int getnumber(vt *pvt)
{
        int n=0;
        char a,buf[10],*p;
        p=buf;
        for(;;){
                a=getkey(pvt);
                if (a==8) {kputchar(a); if (p!=buf) p--; continue; }
                if (a=='\n') { *p=0; break;}
                if (a<'0' || a>'9' ) continue;
                kputchar(a);
                *p++=a;
                if (p==&buf[10]) p--;
        }
        p=buf;
        while (*p) {n*=10; n+=(*p++)-'0';}
        return n;
}


int si_no(vt *pvt)
{
	int x,y;
	gotoxy(0,11);
	kprintf(MSG_YN);
	gettapxy(pvt,&x,&y);
	y>>=3;
	x>>=5;
	if(y==11 && x==1) return 1;
	else return 0;
}

/*----------------------------------------------------------------------------*/
void nyi(vt *pvt)
{
	cls();
	gotoxy(0,9);  kprintf(MSG_NYI);
	gotoxy(0,19); kprintf("<<");
	gettap(pvt);
}

/*---------------------------------------------------------------------------*/
void show_batt(vt *pvt)
{
	int v,i,x,y,cnt,c,oc;
	cls();

	kprintf(MSG_BATT_ST);

	hline(0,159,11,1);
	gotoxy(0,19); kprintf("<<");
	hline(0,159,159-11,1);
	oc=2;
	rectangle(0,80,159,90,1);
	
	v=get_batt();
	for(cnt=0;;){
		if (!cnt) {
		  i=v/1000;
		  gotoxy(0,6); kprintf(MSG_BATT_VOLT,i,(v-i*1000)/10);
		  gotoxy(0,8); kprintf(MSG_BATT_CAP,(v-2200)/10);
		  cursor_off(pvt);
		  c=(v-2200)*159/1000;
		  if (c>oc) filled_rectangle(oc,82,c,88,1);
		  else filled_rectangle(c,82,oc,88,0);
		  oc=c;
		}
		cnt++; if (cnt==16) cnt=0;
		v=(v*(256-2)+2*get_batt())>>8;
		task_sleep(1);
		i=fifo_getnb(pvt->event);
		if (i==EV_KEYBOARD) x=fifo_get(pvt->event);
		if (i==EV_LCD_TAP_PRESS) {
			x=fifo_get(pvt->event);
			y=fifo_get(pvt->event);
			y=(y+4)>>4;
			if (y>=9) return;
		}
	}
}

/*---------------------------------------------------------------------------*/

extern unsigned int slip_ndrop,slip_nrx,slip_ntx;
volatile extern short int txst,rxst;
extern slip_pkt pkt_pool[];
extern slip_pkt rx_q[],tx_q[];
volatile extern slip_pkt *rx_wp,*rx_rp,*tx_wp,*tx_rp;

void slip_st(vt *pvt)
{
	int ev,i,j,k;
	for(;;) {
		cls();
		kprintf("SLIP STATUS\n\n");
		hline(0,159,11,1);
		kprintf("slip_ndrop = %d\n",slip_ndrop);
		kprintf("slip_nrx   = %d\n",slip_nrx); 
		kprintf("slip_ntx   = %d\n\n",slip_ntx); 
		kprintf("RX_STATUS  = %d\n",rxst);
		kprintf("TX_STATUS  = %d\n\n",txst);
		kprintf("buffers : ");
		for (i=0;i<NBUF;i++) kputchar((pkt_pool[i].len)?'U':'_');

		j=((int)rx_wp-(int)rx_q)>>3; k=((int)rx_rp-(int)rx_q)>>3;
		kprintf(MSG_SLIP_RX_Q,j,k);
		j=((int)tx_wp-(int)tx_q)>>3; k=((int)tx_rp-(int)tx_q)>>3;
		kprintf(MSG_SLIP_TX_Q,j,k);
				
		for(i=0;i<10;i++) {
			ev=fifo_getnb(pvt->event);
			if (ev!=-1) break;
			task_sleep(6);
		}
		switch(ev) {
			case EV_KEYBOARD:
				fifo_get(pvt->event);
				break;
			case EV_LCD_TAP_PRESS:
				fifo_get(pvt->event);
				fifo_get(pvt->event);
				return;
			}
	}
}

/*----------------------------------------------------------------------------*/

void show_mem(vt *pvt,int tix)
{
	int i,j,c,fu,fs,mt,x,y;
	
	cls();
	kprintf(MSG_MEM_ST);
	hline(0,159,11,1);
	rectangle(15,32,144,65,1);
	rectangle(15,11*8,144,11*8+33,1);
	hline(0,159,159-11,1);
	gotoxy(0,19); kprintf("<<");
	
	if (tix==0) tix=255;
	for (;;) {
	  fu=fs=mt=0;
	  for (i=0;i<16;i++)
	     for(j=0;j<64;j++) {
	     	if (u_ram_map[(i<<6)+j]) c=1; else { c=0; fu++;}
	     	x=j*2+16; y=i*2+33;
	     	putpixel(x,y,c); putpixel(x+1,y,c);
	     	putpixel(x,y+1,c); putpixel(x+1,y+1,c);
	     	if (u_ram_map[(i<<6)+j]==tix) {
		  putpixel(x,y,0); putpixel(x+1,y+1,0);
	     	  mt++;
	     	}
	     	if (s_ram_map[(i<<6)+j]) c=1; else {c=0; fs++;}
	     	x=j*2+16; y=i*2+11*8+1;
	     	putpixel(x,y,c); putpixel(x+1,y,c);
	     	putpixel(x,y+1,c); putpixel(x+1,y+1,c);
	     	if (s_ram_map[(i<<6)+j]==tix) {
	     	  putpixel(x,y,0); putpixel(x+1,y+1,0);
	     	  mt++;
	     	}
	     }
	  gotoxy(0,3);  kprintf(MSG_MEM_USER,fu>>(10-L2PAGE));
	  gotoxy(0,10); kprintf(MSG_MEM_SUPER,fs>>(10-L2PAGE));
	  if (tix>=0) {
	    gotoxy(0,17);
	    kprintf(MSG_MEM_TASK,mt<<L2PAGE);
	  }
	  cursor_off(pvt);
	  i=gettap(pvt);
	  if (i>=18) return;
	} 
}

/*---------------------------------------------------------------------------*/
extern unsigned long long system_clks;

void tasker(vt *pvt)
{
	short tareas[MAXTASK];
	int i,j,pri,nt,nvt,ev,x,y,sel;
	char s,*p;
	unsigned long long osys,oidle;
	
	sel=-1;
	for(;;) {
	  cls();
	  kprintf(MSG_TASK_HEAD);
	  hline(0,159,11,1);
	  hline(0,159,27,1);

	  // ***** CPU Load ****
	  i=system_clks-osys; osys=system_clks;
	  j=task_table[0].clks-oidle; oidle=task_table[0].clks;
	  i>>=6; j/=i;
	  if(j<0) j=0;
	  if(j>63) j=63;
	  rectangle(92,0,159,7,1);
	  filled_rectangle(94,2,157-j,5,1);
	  
	  for (i=nt=x=0;i<ntask;i++) {
		if (task_table[i].status>KILLED) tareas[nt++]=i;
	  }
	  if (sel>=nt) sel=-1;
	  for (i=0;i<nt;i++) {
		j=task_table[tareas[i]].status;
		if (j>0) s='T';
		else if (j==0) s='R';
		else s='S';
		kprintf("%2d %3d %c ",	tareas[i],task_table[tareas[i]].priority,s);
		if (task_table[tareas[i]].vt!=(vt *)0) {
		  nvt=((int)task_table[tareas[i]].vt-(int)vt_table)/sizeof(vt);
		  kprintf("%2d ",nvt);
		} else kprintf("   ");
		kprintf("%s\n",task_table[tareas[i]].name);
		
	  }

	  if (sel>=0) {
		p=pvt->screen_base;
		i=(sel+4)*8*20; j=i+8*20;
		for (;i<j;i++) p[i]^=0xff;
	  }

	  hline (0,159,159-11,1);
	  gotoxy(0,19); kprintf("<<   KILL GOTO MEM ");
	  cursor_off(pvt);	
	  for(;;){
	  	for (i=16;i;i--) {
			ev=fifo_getnb(pvt->event);
			if (ev!=-1) break;
			task_sleep(4);
		}
		if (ev==-1) break;	//redibujamos cada segundo
		if (ev==EV_FOCUS_ON) break;
		if (ev==EV_KEYBOARD) {
			i=fifo_get(pvt->event);
			if (sel>2) {
			  pri=task_table[tareas[sel]].priority;
			  if (i==K_U) pri++;
			  if (i==K_D) pri--;
			  if (i==K_R) pri+=10; 
			  if (i==K_L) pri-=10;
			  if (pri<1) pri=1; if (pri>99) pri=99;
			  task_table[tareas[sel]].priority=pri;
			}
			break;
		}
		if (ev==EV_LCD_TAP_PRESS) {
			x=fifo_get(pvt->event);
			y=fifo_get(pvt->event);
			if (y>19*8) {
				i=x/40;
				if (i==0) return;	// Principal
				else if (i==3) {	// Memoria
				  if (sel>=0) show_mem(pvt,tareas[sel]);
				  else show_mem(pvt,-1);
				  break;
				}else if (i==2) {	// GoTO
				  if (sel>=0) {
				    if (task_table[tareas[sel]].vt!=(vt *)0) {
				    	switch_vt(task_table[tareas[sel]].vt);
				    	break;
				    }
				  }
				} else if (i==1) {	// Kill
				  if (sel>=0)
				     if (tareas[sel]>3)
				        task_kill(tareas[sel]);
				  sel=-1;
				  break;
				}
			} else {
				i=y/8-4;
				if (i>=0 && i<nt) {
					sel=i;
				}
				break;
			}
		}
	  }
	}
}

/*--------------------------------------------------------------------------*/

void aplicaciones(vt *pvt)
{
	int ix=0;
	file_header *pf;

	cls();
	kprintf(MSG_APP_HEAD);
	for(;;) {
		if((ix=file_sel_int(BINARY_CODE,0,ix))==-1) break;
		pf=file_sel_ix(BINARY_CODE,0,ix);
		file_take_action(pf);
	}
}

/*----------------------------------------------------------------------------*/
extern const char *file_type[];
extern const char *long_file_type[];
extern const char *bin_code_type[];
extern const char *txt_type[];
extern const char *gr_type[];

void file_defrag();

void filer(vt *pvt) {
    int i,j,ix=-1,x,y,n,tipo,subt;
    file_header *pf;
    char *p;
    
    for(;;) {
	cls();
	kprintf(MSG_FILE_DIR);
	if (ix==-1) {
		hline(0,159,11,1);
		for(i=1,n=0;i<NFTYPES;i++) {
			j=file_get_nfiles(i,0);
			n+=j;
			kprintf("%s ",file_type[i]);
			if(j) kprintf(MSG_FILE_NF,j);
			kprintf("\n");
		}
		kprintf(MSG_FILE_TOT,n);
	
		gotoxy(0,16);
		i=file_get_free(0);
		kprintf("FS0 %4d/%d Kb\n",i>>10,(i+file_get_del(0))>>10);
#ifdef DV2MB
		i=file_get_free(1);
		kprintf("FS1 %4d/%d Kb\n",i>>10,(i+file_get_del(1))>>10);
#endif
		hline(0,159,159-11-24,1);
		hline(0,159,159-11,1);
		gotoxy(0,19); kprintf("<<      DFRG");
		gettapxy(pvt,&x,&y); i=y>>3;
		if(i==19) switch(x>>5) {
			case 0:	return;
			case 2: file_defrag(); break;
		}
		tipo=i-1; if (tipo==NFTYPES) tipo=0;
		if(tipo>NFTYPES) continue;
	}
	if (ix==-1) ix=0;
	if((ix=file_sel_int(tipo, 0, ix))==-1) continue;
	pf=file_sel_ix(tipo,0,ix);
	cls();
	kprintf(MSG_FILE_FILE);
	hline(0,159,11,1);
	hline(0,159,159-11,1);
	kprintf("%s\n\n",pf->name);
	kprintf(MSG_FILE_TYPE,long_file_type[pf->type]);
	p="?";
	if(pf->type==BINARY_CODE) p=(char *)bin_code_type[pf->subtype];
	else if(pf->type==TEXT) p=(char *)txt_type[pf->subtype];
	else if(pf->type==GRAPHIC) p=(char *)gr_type[pf->subtype]; 
	kprintf("Subt:%s\n",p);
	kprintf("Size:%d\n",pf->size);
	kprintf("Addr:%x\n",(int)pf+sizeof(file_header));
	gotoxy(0,19); kprintf(MSG_FILE_ACT);
	do gettapxy(pvt,&i,&j);
	while ((j>>3)<19);
	switch((i>>5)) {
	case 1:	file_take_action(pf);
		break;
	case 2:	// delete
		cls();
		gotoxy(0,7); kprintf(MSG_FILE_DEL_Q,pf->name);
		if(si_no(pvt)) {
		    flash_prg_w((long)&(pf->type),0);
		    cls(); gotoxy(0,9); kprintf(MSG_FILE_DEL_A,pf->name);
		    gettap(pvt);
		}
		break;
	}
    }
}

/*****************************************************************************/
void timeset(vt *pvt)
{
        int i,n,x,up=0;
        time tr,ta;

        get_time(&tr,TIME_RTC);
        get_time(&ta,TIME_ALARM);
        for(;;) {
            cls();
            kprintf("RTC   %s %04d\n",MSG_TIME_YEAR,tr.year);
            kprintf("RTC   %s %02d\n",MSG_TIME_MONTH,tr.month);
            kprintf("RTC   %s %02d\n",MSG_TIME_DAY,tr.day);
            kprintf("RTC   %s %02d\n",MSG_TIME_HOUR,tr.hour);
            kprintf("RTC   %s %02d\n",MSG_TIME_MIN,tr.min);
            kprintf("RTC   %s %02d\n\n",MSG_TIME_SEC,tr.sec);

            kprintf("ALARM %s %04d\n",MSG_TIME_YEAR,ta.year);
            kprintf("ALARM %s %02d\n",MSG_TIME_MONTH,ta.month);
            kprintf("ALARM %s %02d\n",MSG_TIME_DAY,ta.day);
            kprintf("ALARM %s %02d\n",MSG_TIME_HOUR,ta.hour);
            kprintf("ALARM %s %02d\n",MSG_TIME_MIN,ta.min);
            kprintf("ALARM %s %02d\n",MSG_TIME_SEC,ta.sec);
            if (up) {
                gotoxy(0,17);
                kprintf(MSG_TIME_UPDATED ,(up==1)?MSG_TIME_RTC:MSG_TIME_ALARM);
            }
            gotoxy (0,19); kprintf("SET RTC   SET ALARM");
            hline(0,159,160-8-5,1);
            up=0;
            gettapxy(pvt,&x,&i); x>>=3; i>>=3;
            if(i<13 && i!=6) {
                gotoxy(12,i); kprintf("       "); gotoxy(12,i);
                n=getnumber(pvt);
            }
            switch(i) {
            case  0: tr.year=n; break;
            case  1: tr.month=n;break;
            case  2: tr.day=n;  break;
            case  3: tr.hour=n; break;
            case  4: tr.min=n;  break;
            case  5: tr.sec=n;  break;
            case  7: ta.year=n; break;
            case  8: ta.month=n;break;
            case  9: ta.day=n;  break;
            case 10: ta.hour=n; break;
            case 11: ta.min=n;  break;
            case 12: ta.sec=n;  break;
            case 19: if (x<10) {
                        set_time(&tr,TIME_RTC);
                        up=1;
                     }else {
                        set_time(&ta,TIME_ALARM);
                        up=2;
                     }
                     break;
            default: return;
            }
       }

}

/*****************************************************************************/

void remoted();
extern char *month_names[];
const
#include "sign.xbm"

extern inline int reversi (unsigned char a)
{
        int i,b=0;

        for (i=0;i<8;i++) {
            b<<=1;
            if (a&1) b++;
            a>>=1;
        }
        return b;
}

void put_sign()
{
        unsigned char *ps,*pd;
        int i,j;

        pd=(unsigned char *)get_screen_base();
        pd=&pd[(160-sign_height)*20+20-sign_width/8];
        ps=sign_bits;
        for (i=0;i<sign_height;i++) {
            for(j=0;j<sign_width/8;j++) *pd++=reversi(*ps++);
            pd=&pd[20-sign_width/8];
        }
}

void shell()
{
	vt *pvt;
	int i,j,ot;
        time t;

	pvt=open_vt(0,1);
	switch_vt(pvt);
	cls();

	for (i=0;i<160;i+=4) {
		line(0,i,i,159,1);
		line(i,0,159,i,1);
	}
	line(0,159,159,159,1);
	line(159,0,159,159,1);

	for (i=30;i<54;i+=2) circle(80,80,i,1);
	gotoxy(8,8); kprintf("FEOS");
	gotoxy(8,11);kprintf(FEOS_VERSION);

	cursor_off((vt *)0);

	//file_init();
	task_start(remoted,0x2000,512,50,"remoted");
	gettap(pvt);
	cls();


//	Menu principal:
        ot=0;
	for(;;) {
		cls();
		kprintf(MSG_MAIN_HEAD);
		hline(0,159,11,1);
		kprintf(MSG_MAIN_M1);
		kprintf(MSG_MAIN_M2);
		kprintf(MSG_MAIN_M3);
		kprintf(MSG_MAIN_M4);
		kprintf(MSG_MAIN_M5);

                hline(0,159,160-24-5,1);
                hline(0,159,160-8-5,1);
                gotoxy(0,19); kprintf("FEOS %s",FEOS_VERSION_L);
                put_sign();

                for (;;) {  // Time update loop
                    get_time(&t,TIME_RTC);
                    if(t.sec!=ot) {
                        gotoxy(0,17);
                        kprintf("%02d/%s/%04d %02d:%02d:%02d",t.day,
                                month_names[t.month-1],t.year,t.hour,
                                t.min,t.sec);
                        ot=t.sec;
                    }
		    //i=gettap(pvt);
                    gettapxynb(pvt,&j,&i);
                    if(i>=0) { i>>=3; break; }
                    task_sleep(2);
                }
		switch(i) {
		case 2:	// utilidades
			do {
			  cls();
			  kprintf(MSG_TOOL_HEAD);
			  hline(0,159,11,1);
			  kprintf(MSG_TOOL_M1);
			  kprintf(MSG_TOOL_M2);
			  kprintf(MSG_TOOL_M3);
			  kprintf(MSG_TOOL_M4);
			  kprintf(MSG_TOOL_M5);
			  kprintf(MSG_TOOL_M6);
			  kprintf(MSG_TOOL_M7);

			  gotoxy(0,19); kprintf("<<");
			  hline(0,159,159-11,1);
			  i=gettap(pvt);
			  switch(i) {
			  case 2: // hora
			  	  timeset(pvt);
				  break;
			  case 4: // Pilas
			  	  show_batt(pvt); break;
			  case 6: // Estado de comunicaciones
			  	  slip_st(pvt); break;
			  case 8: // calibrado
			  	  calibrando=1; break;
				  //pen_calibrate(); break;
			  case 10:  //Bootloader serie
			  	  cls();
			  	  gotoxy(2,9); kprintf(MSG_SERIAL_BOOT);
		        	  asm volatile("
		        	    move.w	#0x2700,%sr
		                    move.l	#0xffffffff,0xfffff304
		                    move.w	#0x2420,0xfffff200
		                    jmp		0xffffff00
				  ");
			  case 12:  // luz
			  	  *(char *)0xfffff409^=0x40;
			  	  break;
			  case 14:  // Ajuste de frec. de muestreo audio
			  	  tunning_tool();
			  	  break;
			  }
			} while (i<18);

			break;
		case 4: // aplicaciones
			aplicaciones(pvt);
			break;
		case 6: // ficheros
			filer(pvt);
			break;
		case 8: // tareas
			tasker(pvt);
			break;
		case 10: // memoria
			show_mem(pvt,-1);
			break;
		}
	}
}
