#include "common.h"
#include "bit.h"
#include "task.h"
#include "fifo.h"
#include "event.h"
#include "lowio.h"
#include "klib.h"
#include "mem.h"
#include "pen.h"
#include "vt.h"
#include "keyboard.h"
#include "lcd.h"
#include "file.h"
#include "flash.h"
#include "slip.h"
#include "remote.h"


void remoted()
{
	//vt *pvt;
	slip_pkt pkt;
	unsigned int *pi;
	unsigned short *ps;
	unsigned char *pc;
	pkt_error *perr;
	pkt_get_nfiles *pgetnfiles;
	pkt_open_file *popenfile;
	file_header *pf;
	char *pr,*pw;
	
	int i,sizer=0,sizew=0;
	
	//pvt=open_vt(0);
	//cls();
	slip_init();
	//kprintf("remoted en marcha\n");
	for(;;) {
	    rx_q_get(&pkt);
	    *(unsigned char *)0xfffffb13=STOPWATCH;
	    ps=(unsigned short *)pkt.data;
	    switch(*ps) {
	    case RMT_ECHO:
	    	//kprintf("Echo\n");
	    	tx_q_put(pkt.data,pkt.len);
	    	break;
	    case RMT_GET_NFILES:
	        pgetnfiles=(pkt_get_nfiles *)ps;
	    	//kprintf("Get NFILES %d %d\n",pgetnfiles->type,pgetnfiles->subtype);
	    	*ps++=RMT_ACK;
	    	pi=(unsigned int *)ps;
	    	*pi=file_get_nfiles(pgetnfiles->type,pgetnfiles->subtype);
	    	tx_q_put(pkt.data,6);
	    	break;
	    case RMT_OPEN_FILE:
	    	popenfile=(pkt_open_file *)ps;
	    	//kprintf("OpenFile %d %d %d\n",popenfile->type,popenfile->subtype,
	    	//	popenfile->index);
	    	pf=file_sel_ix(popenfile->type,popenfile->subtype,popenfile->index);
		if(!pf) {
			*ps++=RMT_ERROR;
			*ps=ERROR_INVALID;
			tx_q_put(pkt.data,4);
			break;
		}
	    	pr=(char *)((int)pf+sizeof(file_header));
	    	sizer=pf->size;
	    	*ps++=RMT_ACK;
	    	memcpy((char *)ps,(char *)pf,sizeof(file_header));
	    	tx_q_put(pkt.data,2+sizeof(file_header));
	    	break;
	    case RMT_READ_FILE:
	    	//kprintf("Read\n");
	    	i=sizer; if(i>MAXLEN-2) i=MAXLEN-2;
	    	*ps++=RMT_ACK;
	    	if(i) memcpy((char *)ps,pr,i);
	    	tx_q_put(pkt.data,i+2);
	    	pr=(char *)((int)pr+i);
	    	sizer-=i;
	    	break;
	    case RMT_CREAT_FILE:
	    	pf=(file_header *)++ps; ps--;
	    	//kprintf("Creat %x %d %d\n len %d\n%s\n",pf->magic,pf->type,
	    	//	pf->subtype,pf->size,pf->name);
	    	pf=file_creat(pf);
	    	if(pf) {
	    		pw=(char *)((int)pf+sizeof(file_header));
	    		sizew=pf->size;
	    		*ps=RMT_ACK;
	    		tx_q_put(pkt.data,2);
	    	} else {
	    		*ps++=RMT_ERROR;
	    		*ps=ERROR_NO_SPACE;
	    		tx_q_put(pkt.data,4);
	    	}
	    	break;
	    case RMT_WRITE_FILE:
	    	i=pkt.len-2;
	    	//kprintf("Write %d\n",i);
	    	if (!sizew) {
	    		*ps++=RMT_ERROR;
	    		*ps=ERROR_ABORTED;
	    		tx_q_put(pkt.data,4);
	    		break;
	    	}
	    	if (i>sizew) {
	    		flash_prg_blk(pw,&pkt.data[2],sizew);
	    		sizew=0;
	    		*ps++=RMT_ERROR;
	    		*ps=ERROR_NO_SPACE;
	    		tx_q_put(pkt.data,4);
	    		break;
	    	}
	    	flash_prg_blk(pw,&pkt.data[2],i);
	    	pw=(char *)((int)pw+i);
	    	sizew-=i;
	    	*ps=RMT_ACK;
	    	tx_q_put(pkt.data,2);
	    	break;
	    
	    case RMT_OPEN_SCREEN:
	    	//kprintf("Open screen\n");
	    	pr=(unsigned char *)get_screen_base();
                //*(unsigned char **)0xfffffa00;
	    	sizer=3200<<((*(volatile unsigned char *)0xfffffa20)&3);
	    	*ps=RMT_ACK;
	    	tx_q_put(pkt.data,2);
	    	break;
	    	
	    default:
	    	//kprintf("Error: code=%x\n",(int)*ps);
	    	*ps++=RMT_ERROR;
	    	*ps=ERROR_INVALID;
	    	tx_q_put(pkt.data,4);
	    	break;
	    }

	}
}
