#include "init.h"
#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "../keyboard.h"
#include "../file.h"
#include "ulib.h"

#include "font_5x7.c"

#define FW 5
#define FH 7
#define EFH 7
#define FMASK 0xf8000000

#define NC (160/FW)
#define NR (160/EFH)

wrchar(char *base,int x,int y,unsigned char a)
{
	unsigned int i,j,dis,m,*pi;
	unsigned char *p,*pf;
	
	pf=(char *)&fontdata[FH*(unsigned int)a];
	
	i=x*FW;
	pi=(unsigned int *)&base[EFH*20*y+((i>>4)<<1)];
	dis=i&15;
	
	m=FMASK; m>>=dis;
	for (j=0;j<EFH;j++) {
		i=(*pf++); i<<=24-dis;
		*pi|=m; *pi^=m;
		*pi|=i;
		pi=&pi[5];
	}
}

void main()
{
	vt *pvt;
	file_header *pf;
	char *pini,*pfin,*pline,*p,a,*base;
	int i,j,k,x,offx=0,maxx,key=0;
	
	
	pvt=(vt *)syscall(OPEN_VT,0);
	syscall(VT_TO_FG);
	syscall(CLS);
	printf("miniTEXT READER.");
	
	base=(char *)syscall(VT_GET_SCREEN_BASE);
	
	i=syscall(FILE_SEL_INT,TEXT,0,0);
	if (i<0) syscall(TASK_EXIT);
	pf=(file_header *)syscall(FILE_SEL_IX,TEXT,0,i);

	pini=(char *)((int)pf+sizeof(file_header));
	pfin=(char *)((int)pf+sizeof(file_header)+pf->size);
	pline=pini;

	for(;;) {
		syscall(CLS);
		syscall(CURSOR_OFF); 
		p=pline;
		maxx=0;
		for(i=0;i<NR;i++){
		    x=0;
		    for(;;) {
		    	if (p==pfin) break;
		    	a=*p++;
			if(a=='\n') break;
			if(a=='\r') continue;
			if(a==8) { if(x>0) x--; continue; }
			if(a=='\t') { x=(x+8)&0xfff8; continue; }
			if(x>=offx && x<offx+NC) wrchar(base,x-offx,i,a);
			x++;
		    }
		    if(x>maxx) maxx=x;
		    if (p==pfin) break;
		}
		for(;;) {
			for(j=0;j<6;j++) {
			    i=syscall(VT_GET_EVENT_NB);
			    if (i!=-1) break;
			    syscall(TASK_SLEEP,1);
			}
			if (i==EV_LCD_TAP_PRESS) syscall(TASK_EXIT);
			if (i==EV_KEYBOARD_REL) key=0;
			if (i==EV_KEYBOARD) key=syscall(VT_GET_EVENT);
			switch(key) {
			    case 'u':
			    	for(k=0;k<10;k++) {
			    	    p=pline; p--;
			    	    do p--; while(p>pini && *p!='\n');
			    	    if (*p=='\n') p++;
			    	    if (p>=pini) pline=p;
			    	}
			    	break;
			    case K_U:
			    	p=pline; p--;
			    	do p--; while(p>pini && *p!='\n');
			    	if (*p=='\n') p++;
			    	if (p>=pini) pline=p;
			    	break;
			    case 'd':
			   	for(k=0;k<10;k++) {
			    	    p=pline;
			    	    do p++; while(p<pfin && *p!='\n');
			    	    if(*p=='\n') p++;
			    	    if(p<pfin) pline=p;
			    	}
			    	break;
			    case K_D:
			    	p=pline;
			    	do p++; while(p<pfin && *p!='\n');
			    	if(*p=='\n') p++;
			    	if(p<pfin) pline=p;
			    	break;
			    case K_L:
			    	if(offx) offx--;
			    	break;
			    case K_R:
			    	if(offx+NC<maxx) offx++;
			    	break;
			    case '\n':
			    	offx=0;
			    	break;
			    case 'b':
			    	offx=0;
			    	pline=pini;
			    	break;
			}
			if(key) break;
		}
	}
}

