#include "init.h"
#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "../keyboard.h"
#include "../file.h"
#include "ulib.h"

/************* Variables Globales ************/

typedef unsigned char uchar;

#define ANCHO 	10
#define ALTO	19

uchar campo[ALTO+1][ANCHO+2],oldc[ALTO+1][ANCHO+2];
uchar pieza[4][4];

const uchar piezas[7][2][4]={
	1,1,1,1,	// 0 Barra
	0,0,0,0,
	2,2,2,0,	// 1 /L
	0,0,2,0,
	0,3,3,3,	// 2 L
	0,3,0,0,
	0,0,4,4,	// 3 S
	0,4,4,0,
	5,5,0,0,	// 4 /S
	0,5,5,0,
	0,6,6,6,	// 5 T
	0,0,6,0,
	0,7,7,0,	// 6 Cuadrado
	0,7,7,0
};

int xp,yp;	// Posicin de la pieza

/************** RUTINAS asociadas al SISTEMA ****************/

static unsigned long srand;
int rand()
{
    srand=srand* 1103515245 + 12345;
    return (srand>>16)&0x7fff;
}

uchar *video;

void cuadro(int x,int y, int tipo)
{
    int i;
    uchar *p;
    const uchar cuad[8]={0xaa, 0xff, 0xc2, 0xc3, 0xc2, 0xc3, 0xfe, 0xff};

    p=&video[y*20*8+x];
    if (tipo) for (i=0;i<8;i++) {*p=cuad[i]; p+=20;}
    else for (i=0;i<8;i++) {*p=0; p+=20;}
}

char getch_vt()
{
	static uchar lcd=0,rep=4,key=0;;
	
	switch(syscall(VT_GET_EVENT_NB)) {
	case EV_KEYBOARD:
		key=syscall(VT_GET_EVENT);
		rep=4;
		return key;
	case EV_LCD_TAP_PRESS:
		syscall(VT_GET_EVENT);
		syscall(VT_GET_EVENT);
		lcd^=1;
		return (lcd)?'P':'C';
	case EV_FOCUS_OFF:	return 'P';
	case EV_FOCUS_ON:	return 'C';
	case EV_KEYBOARD_REL:
		key=0; rep=4;
	}
	if (key) {
		if (!(--rep)) {
			rep=4;
			return key;
		}
	}
	return 0;
}

/**************** Rutinas del CORE del programa ***************/

int testpos(int x, int y)
{
	int i,j;
	for (i=0;i<4;i++)
		for (j=0;j<4;j++) {
			if (x+j<0) continue;
			if (x+j>ANCHO+1) continue;
			if (y+i<0) continue;
			if (y+i>ALTO) continue;
			if (campo[y+i][x+j] && pieza[i][j]) return 1;
		}
	return 0;
}

void rota(int giro)
{
	int i,j;
	uchar tmp[4][4];
	if (giro>0) {		//Giro antihorario de 90
		for (i=0;i<4;i++)
			for (j=0;j<4;j++) tmp[3-j][i]=pieza[i][j];
		for (i=0;i<4;i++)
			for (j=0;j<4;j++) pieza[i][j]=tmp[i][j];
	}
	if (giro<0) {		//Giro horario de 90
		for (i=0;i<4;i++)
			for (j=0;j<4;j++) tmp[j][3-i]=pieza[i][j];
		for (i=0;i<4;i++)
			for (j=0;j<4;j++) pieza[i][j]=tmp[i][j];
	}
}

void init()
{
	int i,j;
	
	for (i=0;i<ALTO;i++) {
		for (j=1;j<ANCHO+1;j++) campo[i][j]=0;
		campo[i][0]=campo[i][ANCHO+1]=8;
	}
	for (j=0;j<ANCHO+2;j++) campo[i][j]=8;
	for (i=0;i<ALTO+1;i++) for(j=0;j<ANCHO+2;j++) oldc[i][j]=0;
	for (i=0;i<4;i++) for (j=0;j<4;j++) pieza[i][j]=0;
	xp=4; yp=-4;
	srand=syscall(RDTSC);
}

void display()
{
	int i,j,ip,jp,ch;
	
	for (i=0;i<ALTO+1;i++) {
	    for (j=0;j<ANCHO+2;j++) {
		ch=0;
		if (campo[i][j]) ch=campo[i][j];
		ip=i-yp;
		if (ip>=0 && ip<4) {
		    jp=j-xp;
		    if (jp>=0 && jp<4) if (pieza[ip][jp]) ch=pieza[ip][jp];
		}
		if (oldc[i][j]!=ch) {
		    oldc[i][j]=ch;
		    cuadro(j,i,ch);
		}
	    }
	}
}

/************** Programa **************/
#define INIDEL 15	//0.5 Seg
#define DELSTEP 10	//incremento de velocidad cada DELSTEP lineas


main()
{
    int i,j,k,np,sigp,del,dl,npiezas,nlineas,max;
	
    syscall(OPEN_VT,0);
    syscall(VT_TO_FG);
    video=(uchar *)syscall(VT_GET_SCREEN_BASE);
    max=0;
    for(;;) {	
	syscall(CLS);
 	syscall(CURSOR_OFF);
	init();
	display();
	sigp=rand()%7;
	npiezas=nlineas=0;
	syscall(GOTOXY,14,12); printf("MAX");
	syscall(GOTOXY,14,13); printf("%d",max);
	for(;;) {
		// Sacamos una pieza aleatoria
		npiezas++;
		np=sigp;
		sigp=rand()%7;
		// Dibujamos la siguiente pieza
		for (i=0;i<2;i++)
		    for(j=0;j<4;j++)
		    	cuadro(ANCHO+3+j,i,piezas[sigp][i][j]);
		// Copiamos pieza actual a su bitmap
		for (i=0;i<4;i++)
		    for (j=0;j<4;j++)
			pieza[i][j]=(i==0 || i==3)?0:piezas[np][i-1][j];
		// Posiciones iniciales
		xp=4; yp=-2;
		// Si no se puede ni empezar: Game Over
		if (testpos(xp,yp)) break;
		del=INIDEL-nlineas/DELSTEP; if (del<1) del=1; dl=del;
		for (;;) { // Bucle de caida
			np=0;
			switch(getch_vt()) {
			case K_L:	if (!testpos(xp-1,yp)) xp--;
					np=1;
					break;
			case K_R:	if (!testpos(xp+1,yp)) xp++;
					np=1;break;
			case K_U:	rota(1);
					if(testpos(xp,yp)) rota(-1);
					np=1;
					break;
			case K_D:	while (!testpos(xp,yp+1)) {
						yp++;
						display();
						//usleep(50000);
						syscall(TASK_SLEEP,3);
						}
					goto nuevapieza;
			case 'P':	while(getch_vt()!='C')
						syscall(TASK_SLEEP,3);
					break;
			
			}
			if (!(--dl)) {	// ABAJO
				dl=del;
				if (testpos(xp,yp+1)) break;
				yp++;
				np=1;
			}
			if (np) display();
			//usleep(50000);
			syscall(TASK_SLEEP,3);
		}
nuevapieza:	// Aadimos la pieza al campo
		for (i=0;i<4;i++)
		    for (j=0;j<4;j++)
		    	if (yp+i>=0 && yp+i<ALTO && xp+j>0 && xp+j<ANCHO+1)
		    	    campo[yp+i][xp+j]|=pieza[i][j];
		// Comprobamos si hay que "quemar" alguna lnea
		for (i=0;i<ALTO;i++) {
		    for (j=1;j<ANCHO+1;j++) if (!campo[i][j]) break;
		    if (j==ANCHO+1) {	// Linea completa: Scroll hacia abajo
			for (j=1;j<ANCHO+1;j++)
			    for (k=i;k>=0;k--)
				campo[k][j]=(k)?campo[k-1][j]:0;
			nlineas++;
			syscall(GOTOXY,14,10);
			printf("%d",nlineas);
			if (nlineas>max) {
				max=nlineas;
				syscall(GOTOXY,14,13); printf("%d",max);
			}
			syscall(CURSOR_OFF);
		    }
		}
	}
    while(getch_vt()!=K_U) syscall(TASK_SLEEP,3);
    }
}
