#include "init.h"
#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "ulib.h"
#include "fix_fft.h"

extern inline unsigned char *getp()
{
char *pa;
asm volatile("trap #2\n	move.l %%d0,%0":"=a"(pa));
return pa;
}

#define BLEN	8192

#define FS	7866
#define F0	1000
#define F1	1850
#define BR	42

unsigned short DF0;	//(F0*1024/FS)
unsigned short DF1;	//(F1*1024/FS)
unsigned short SPB;	//(FS/BR)

unsigned char *abuf,*ard;
short buf1[256],buf2[256],buf3[256],buf4[256];
unsigned short ixbuf=0;
static short yf0i=0,yf0q=0,yf1i=0,yf1q=0;
static unsigned short dds0=0,dds1=0;

asm("
	.globl demodula
demodula:
	movem.l %d1-%d3/%d7/%a0-%a2,-(%sp)
1:	trap	#2
	cmp.l	ard(%a5),%d0
	bne	2f
	pea.l	1
	pea.l	1
	bsr	syscall
	addq.l	#8,%sp
	bra	1
2:	movea.l	ard(%a5),%a0
	clr.l	%d7
	move.b	(%a0)+,%d7
	movea.l	abuf(%a5),%a1
	lea.l	8192(%a1),%a2
	cmpa.l	%a0,%a2
	bne	3f
	move.l	%a1,%a0
3:	move.l	%a0,ard(%a5)
	sub.l	#128,%d7
	
	move.w	ixbuf(%a5),%d1
	add.w	%d1,%d1
	
	move.l	%d7,%d0
	btst.b	#1,dds0(%a5)
	beq	4f
	neg.l	%d0
4:	lea.l	buf1(%a5),%a0
	move.w	yf0i(%a5),%d2
	sub.w	(%a0,%d1),%d2
	add.w	%d0,%d2
	move.w	%d0,(%a0,%d1)
	move.w	%d2,yf0i(%a5)

	move.l	%d7,%d0
	move.w	dds0(%a5),%d3
	add.w	#256,%d3
	btst.b	#9,%d3
	beq	5f
	neg.l	%d0
5:	lea.l	buf2(%a5),%a0
	move.w	yf0q(%a5),%d2
	sub.w	(%a0,%d1),%d2
	add.w	%d0,%d2
	move.w	%d0,(%a0,%d1)
	move.w	%d2,yf0q(%a5)

	move.l	%d7,%d0
	btst.b	#1,dds1(%a5)
	beq	6f
	neg.l	%d0
6:	lea.l	buf3(%a5),%a0
	move.w	yf1i(%a5),%d2
	sub.w	(%a0,%d1),%d2
	add.w	%d0,%d2
	move.w	%d0,(%a0,%d1)
	move.w	%d2,yf1i(%a5)

	move.l	%d7,%d0
	move.w	dds1(%a5),%d3
	add.w	#256,%d3
	btst.b	#9,%d3
	beq	7f
	neg.l	%d0
7:	lea.l	buf4(%a5),%a0
	move.w	yf1q(%a5),%d2
	sub.w	(%a0,%d1),%d2
	add.w	%d0,%d2
	move.w	%d0,(%a0,%d1)
	move.w	%d2,yf1q(%a5)

	move.w	DF0(%a5),%d0
	add.w	%d0,dds0(%a5)
	andi.w	#1023,dds0(%a5)

	move.w	DF1(%a5),%d0
	add.w	%d0,dds1(%a5)
	andi.w	#1023,dds1(%a5)

	lsr.l	#1,%d1
	addq.l	#1,%d1
	cmp.w	SPB(%a5),%d1
	bne	8f
	clr.l	%d1
8:	move.w	%d1,ixbuf(%a5)

	clr.l	%d1
	clr.l	%d0
	move.w	yf0i(%a5),%d0
	bpl	M1
	neg.w	%d0
M1:	add.l	%d0,%d1
	move.w	yf0q(%a5),%d0
	bpl	M2
	neg.w	%d0
M2:	add.l	%d0,%d1
	move.w	yf1i(%a5),%d0
	bpl	M3
	neg.w	%d0
M3:	sub.l	%d0,%d1
	move.w	yf1q(%a5),%d0
	bpl	M4
	neg.w	%d0
M4:	sub.l	%d0,%d1

	move.l	%d1,%d0
	movem.l	(%sp)+,%d1-%d3/%d7/%a0-%a2
	rts
");


int DS;		//(SPB/32)

int dpll()
{
	static int x0;
	int x,i,f;
	for(i=f=0;i<SPB;i++) {
		x=demodula();
		//syscall(PUTPIXEL,i,120-(x>>7),1);
		if ((x^x0)&0x80000000) {
			if (!f) {
				if (i<SPB/2) i+=DS; else i-=DS;
				f=1;
			}
		}
		x0=x;
	}
	f=(x>0)?0x80:0;
	return f;
}

#define NBIT 8

unsigned int serie()
{
	int i;
	unsigned int d;
	
	/* Esperamos 0.5 bits antes de usar DPLL */
	for (i=SPB/2;i;i--) {
		if (demodula()>0) i=SPB/2;
	}
	d=0;
	for (i=NBIT;i;i--) {
		d>>=1;
		d|=dpll();
	}
	
	dpll();	//stop bit
	
	d>>=8-NBIT;
	return d;
}

void main()
{
	vt *pvt;
	int i;

	pvt=(vt *)syscall(OPEN_VT,0);
	if (!pvt) syscall(TASK_EXIT);
	syscall(VT_TO_FG);
	
	abuf=ard=(unsigned char *)syscall(KMALLOC,BLEN);
	if(!abuf) syscall(TASK_EXIT);
	
	DF0=(F0*1024/FS);
	DF1=(F1*1024/FS);
	SPB=(FS/BR);
	DS=(SPB/32);

	syscall(CLS);
	if (syscall(AUDIO_START,(int)abuf,BLEN)) {
		syscall(GOTOXY,0,18);
		printf("Error AUDIO_START");
		syscall(TASK_SLEEP,640);
		syscall(TASK_EXIT);
	}

	for(;;) {
	    i=serie();
	    syscall(PUTCHAR,i);
	    i=syscall(VT_GET_EVENT_NB);
	    if (i==EV_LCD_TAP_PRESS) break;
	    if (i==EV_KEYBOARD) syscall(VT_GET_EVENT);
	}
	syscall(TASK_SLEEP,320);
}
