#include "init.h"
#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "ulib.h"
#include "fix_fft.h"

extern inline unsigned char *getp()
{
char *pa;
asm volatile("trap #2\n	move.l %%d0,%0":"=a"(pa));
return pa;
}

#define BLEN	8192

#define FS	(7866/2)
#define F0	500
#define F1	600
#define BR	50

#define DF0	(F0*1024/FS)
#define DF1	(F1*1024/FS)
#define SPB	(FS/BR)

unsigned char *abuf,*ard;
char buf1[SPB],buf2[SPB],buf3[SPB],buf4[SPB];
int ixbuf=0;

int demodula()
{
	static int yf0i=0,yf0q=0,yf1i=0,yf1q=0;
	static unsigned short dds0=0,dds1=0;
	static int os=128;
	int x,x0i,x0q,x1i,x1q;
	
	while(getp()==ard) syscall(TASK_SLEEP,1);
	x=*ard++;
	if(ard==&abuf[BLEN]) ard=abuf;
	while(getp()==ard) syscall(TASK_SLEEP,1);
	x=*ard++;
	if(ard==&abuf[BLEN]) ard=abuf;
	x-=128;
	
	// MIX
	if(dds0&0x200) x0i=-x; else x0i=x;
	if((dds0+256)&0x200) x0q=-x; else x0q=x;
	if(dds1&0x200) x1i=-x; else x1i=x;
	if((dds1+256)&0x200) x1q=-x; else x1q=x;
	
	//DDS
	dds0+=DF0; dds0&=1023;
	dds1+=DF1; dds1&=1023;
	
	// LOW-PASS (40 Hz)
	yf0i-=buf1[ixbuf]; yf0i+=x0i; buf1[ixbuf]=x0i;
	yf0q-=buf2[ixbuf]; yf0q+=x0q; buf2[ixbuf]=x0q;
	yf1i-=buf3[ixbuf]; yf1i+=x1i; buf3[ixbuf]=x1i;
	yf1q-=buf4[ixbuf]; yf1q+=x1q; buf4[ixbuf]=x1q;
	
	ixbuf++; if (ixbuf==SPB) ixbuf=0;
	
	//Clculo Ampl.

	if (yf0i<0) x=yf0i; else x=-yf0i;
	if (yf0q<0) x+=yf0q; else x-=yf0q;
	if (yf1i<0) x-=yf1i; else x+=yf1i;
	if (yf1q<0) x-=yf1q; else x+=yf1q;
	
	return x;
	//return ((int)getp()-(int)ard)&8191;
}

#define DS (SPB/32)

int dpll()
{
	static int x0;
	int x,i,f;
	for(i=f=0;i<SPB;i++) {
		x=demodula();
		syscall(PUTPIXEL,i,120-(x>>7),1);
		if ((x^x0)&0x80000000) {
			if (!f) {
				if (i<SPB/2) i+=DS; else i-=DS;
				f=1;
			}
		}
		x0=x;
	}
	f=(x>0)?0x80:0;
	return f;
}

#define NBIT 8

unsigned int serie()
{
	int i;
	unsigned int d;
	
	/* Esperamos 0.5 bits antes de usar DPLL */
	for (i=SPB/2;i;i--) {
		if (demodula()>0) i=SPB/2;
	}
	d=0;
	for (i=NBIT;i;i--) {
		d>>=1;
		d|=dpll();
	}
	
	dpll();	//stop bit
	
	d>>=8-NBIT;
	return d;
}

void main()
{
	vt *pvt;
	int i;

	pvt=(vt *)syscall(OPEN_VT,0);
	if (!pvt) syscall(TASK_EXIT);
	syscall(VT_TO_FG);
	
	abuf=ard=(unsigned char *)syscall(KMALLOC,BLEN);
	if(!abuf) syscall(TASK_EXIT);

	syscall(CLS);
	if (syscall(AUDIO_START,(int)abuf,BLEN)) {
		syscall(GOTOXY,0,18);
		printf("Error AUDIO_START");
		syscall(TASK_SLEEP,640);
		syscall(TASK_EXIT);
	}

	for(;;) {
	    i=serie();
	    syscall(PUTCHAR,i);
	    i=syscall(VT_GET_EVENT_NB);
	    if (i==EV_LCD_TAP_PRESS) break;
	    if (i==EV_KEYBOARD) syscall(VT_GET_EVENT);
	}
	syscall(TASK_SLEEP,320);
}
