#include "init.h"
#include "../common.h"
#include "../syscall.h"
#include "../event.h"
#include "../time.h"
#include "ulib.h"

const int c=200;
int x=100;
int y;

#undef syscall
int syscall(int code,...)
{
asm volatile("trap #0");
}

main()
{
	vt *pvt;
        time ts;
	int i;

	pvt=(vt *)syscall(OPEN_VT,0);
	syscall(VT_TO_FG);
	syscall(CLS);

	for(;;) {
                syscall(TIME_GET_RTC,(int)&ts);
                printf("\r%04d/%02d/%02d %02d:%02d:%02d",
                        ts.year,ts.month,ts.day,ts.hour,ts.min,ts.sec);
		i=syscall(VT_GET_EVENT_NB);
		if (i==EV_LCD_TAP_PRESS) break;
		if (i==EV_KEYBOARD) syscall(VT_GET_EVENT);
                syscall(TASK_SLEEP,16);
	}
}
