#include "init.h"
#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "ulib.h"
#include "fix_fft.h"

extern inline unsigned char *getp()
{
char *pa;
asm volatile("trap #3\n	move.l %%d0,%0":"=a"(pa));
return pa;
}

#include "fix_fft.c"

void main()
{
	vt *pvt;
	int i,psin,di,ddi;
	unsigned char *abuf,*p,*pp;

	pvt=(vt *)syscall(OPEN_VT,0);
	if (!pvt) syscall(TASK_EXIT);
	syscall(VT_TO_FG);
	
	abuf=(unsigned char *)syscall(KMALLOC,1024);	
	if(!abuf) syscall(TASK_EXIT);

	syscall(CLS);
	syscall(GOTOXY,0,9); printf("PWM en marcha");

	if((i=syscall(PWM_START,(int)abuf,1024))){	
		printf("\n\nError PWM_START %d",i);
		syscall(TASK_SLEEP,0);
	}

	psin=0; di=800; ddi=1;
	p=abuf;
		
	for(;;) {
		for(;;) {	//LLenamos buffer
			pp=p;
			pp++; if (pp==&abuf[1024]) pp=abuf;
			if(pp==getp()) break;
			i=Sinewave[psin]>>8; i+=128;
			*p=(unsigned char)(i&0xff);
			p=pp;
			psin+=di>>4; psin&=1023;
			di+=ddi;
			if (di==8000) ddi=-1;
			if (di==800) ddi=1;
		}
		
		syscall(TASK_SLEEP,4);	// Descansamos hasta 1/2 Fifo

		i=syscall(VT_GET_EVENT_NB);
		switch(i) {
		case EV_LCD_TAP_PRESS:
			syscall(TASK_EXIT);
		case EV_KEYBOARD:
			i=syscall(VT_GET_EVENT);
			break;
		}
	}
}
