#include "init.h"
#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "ulib.h"
#include <math.h>
#include <string.h>
#include <ctype.h>

typedef struct {
	/* Parmetros geomtricos */
	char nombre[16];
	short tipo;	// P o N
	float tox;	// Espesor del xido
	float vto;	// tensin umbral
	float L;	// Longitud del canal
	float W;	// Anchura del canal
	float uo;	// Movilidad del canal
	float nsub;	// Dopado del sustrato
	/* Parmetros derivados */
	float kp;
	float beta;
	float gamma;
	float n;
	float lambda;
} mos_param;

char getch_vt()
{
	for (;;){
		switch(syscall(VT_GET_EVENT)) {
			case EV_KEYBOARD:
				return syscall(VT_GET_EVENT);
				break;
			case EV_LCD_TAP_PRESS:
				//syscall(TASK_EXIT);
				syscall(VT_GET_EVENT);
				syscall(VT_GET_EVENT);
				break;
		}
	}
}

void getsn_vt(char *buf,int maxn, vt *pvt)
{
	char a,*p;
	p=buf;
	for(;;){
		a=getch_vt(); putchar(a);
		if (a==8) { if (p!=buf) p--; continue; }
		if (a=='\n') { *p=0; return;}
		*p++=a;
		if (p==&buf[maxn]) p--;
	}
}


void dibuja_seccion_mos(int x,int y)
{
	syscall(FILLED_RECTANGLE,x+4,y+16,x+20,y+24,2);	//Fuente
	syscall(RECTANGLE,x+4,y+16,x+20,y+24,3);
	syscall(FILLED_RECTANGLE,x+40,y+16,x+56,y+24,2);//Drenador
	syscall(RECTANGLE,x+40,y+16,x+56,y+24,3);
	syscall(RECTANGLE,x+20,y,x+40,y+16,3);		//Oxido de puerta
	syscall(FILLED_RECTANGLE,x+22,y+4,x+38,y+12,3);	//Puerta
	syscall(RECTANGLE,x,y+16,x+60,y+40,3);		//sustrato
}
void dibuja_frontal_mos(int x,int y)
{
	syscall(FILLED_RECTANGLE,x,y+4,x+24,y+36,2);	//Fuente
	syscall(RECTANGLE,x+4,y+8,x+20,y+32,3);
	syscall(LINE,x+4,y+8,x+20,y+32,3);
	syscall(LINE,x+20,y+8,x+4,y+32,3);
	syscall(FILLED_RECTANGLE,x+36,y+4,x+60,y+36,2);	//Fuente
	syscall(RECTANGLE,x+40,y+8,x+56,y+32,3);
	syscall(LINE,x+40,y+8,x+56,y+32,3);
	syscall(LINE,x+56,y+8,x+40,y+32,3);
	syscall(RECTANGLE,x+24,y,x+36,y+40,3);		//Puerta
}

#define E0 8.841941e-12
#define EOX 3.9
#define ESI 11

void deriva_param(mos_param *mos)
{
	float cox,ve;
	cox=E0*EOX*1e6/mos->tox; // F/cm2
	mos->kp=mos->uo*cox;
	mos->beta=mos->W/mos->L*mos->kp;
	mos->gamma=5.88e-16*sqrt(mos->nsub)/cox;
	mos->n=1+mos->gamma*0.5976;
	ve=(mos->tipo)?7:4;
	mos->lambda=1./ve/mos->L;
}

void get_param(vt *pvt,mos_param *mos)
{
	int ev,x,y,i;
	char buf[14];
	
	for(;;) {
		syscall(CLS);
		syscall(GOTOXY,0,19); printf("<<");
		syscall(HLINE,0,159,160-12,3);
		syscall(GOTOXY,0,0);
		printf("ID  : %s\n",mos->nombre);
		printf("Tipo: %c\n",mos->tipo?'P':'N');
		printf("TOX : %f\n",mos->tox);
		printf("VTO : %f\n",mos->vto);
		printf("L   : %f\n",mos->L);
		printf("W   : %f\n",mos->W);
		printf("   : %f\n",mos->uo);
		printf("NSUB: %f\n",mos->nsub);
		syscall(HLINE,0,159,68,3);
		//deriva_param(mos); 
		syscall(GOTOXY,0,9);
		printf("kp : %f\n",mos->kp);
		printf("  : %f\n",mos->beta);
		printf("gam: %f\n",mos->gamma);
		printf("n  : %f\n",mos->n);
		printf("lam: %f\n",mos->lambda);
		
		syscall(GOTOXY,0,19); printf("<<");
		syscall(HLINE,0,159,159-11,3);

		ev=syscall(VT_GET_EVENT);
		switch(ev) {
		case EV_KEYBOARD:
			syscall(VT_GET_EVENT);
			break;
		case EV_LCD_TAP_PRESS:
			x=syscall(VT_GET_EVENT);
			y=syscall(VT_GET_EVENT);
			y>>=3;
			syscall(FILLED_RECTANGLE,40,y<<3,159,(y<<3)+7,0);
			switch(y) {
			case 0:	//Tox
				syscall(GOTOXY,0,19);
				printf("Identificador");
				syscall(GOTOXY,6,0);
				getsn_vt(mos->nombre,13,pvt);
				break;
			case 1:	//Tipo
				syscall(GOTOXY,0,19); printf("Tipo N o P");
				syscall(GOTOXY,6,1);
				i=getch_vt(pvt);
				if (i=='n' || i=='N') mos->tipo=0;
				if (i=='p' || i=='P') mos->tipo=1;
				deriva_param(mos);
				break;
			case 2:	//Tox
				syscall(GOTOXY,0,19);
				printf("Espesor xido ()");
				syscall(GOTOXY,6,2);
				getsn_vt(buf,13,pvt);
				mos->tox=atof(buf);
				deriva_param(mos);
				break;
			case 3:	//vto
				syscall(GOTOXY,0,19);
				printf("Tensin umbral (V)");
				syscall(GOTOXY,6,3);
				getsn_vt(buf,13,pvt);
				mos->vto=atof(buf);
				deriva_param(mos);
				break;
			case 4:	// L
				syscall(GOTOXY,0,19);
				printf("Longitud canal ()");
				syscall(GOTOXY,6,4);
				getsn_vt(buf,13,pvt);
				mos->L=atof(buf);
				deriva_param(mos);
				break;
			case 5:	// W
				syscall(GOTOXY,0,19);
				printf("Anchura canal ()");
				syscall(GOTOXY,6,5);
				getsn_vt(buf,13,pvt);
				mos->W=atof(buf);
				deriva_param(mos);
				break;
			case 6:	// Uo
				syscall(GOTOXY,0,19);
				printf("Movilidad (cm/Vs)");
				syscall(GOTOXY,6,6);
				getsn_vt(buf,13,pvt);
				mos->uo=atof(buf);
				deriva_param(mos);
				break;
			case 7:	// Nsub
				syscall(GOTOXY,0,19);
				printf("Dopado sust. (cm)");
				syscall(GOTOXY,6,7);
				getsn_vt(buf,13,pvt);
				mos->nsub=atof(buf);
				deriva_param(mos);
				break;

			case 9:	// KP
				syscall(GOTOXY,0,19);
				printf("KP (A/V)");
				syscall(GOTOXY,5,9);
				getsn_vt(buf,14,pvt);
				mos->kp=atof(buf);
				break;
				
			case 10: // beta
				syscall(GOTOXY,0,19);
				printf("Beta (A/V)");
				syscall(GOTOXY,5,10);
				getsn_vt(buf,14,pvt);
				mos->beta=atof(buf);
				break;
			case 11: // gamma
				syscall(GOTOXY,0,19);
				printf("Gamma");
				syscall(GOTOXY,5,11);
				getsn_vt(buf,14,pvt);
				mos->gamma=atof(buf);
				break;
			case 12: // n
				syscall(GOTOXY,0,19);
				printf("n");
				syscall(GOTOXY,5,12);
				getsn_vt(buf,14,pvt);
				mos->n=atof(buf);
				break;
			case 13: // lambda
				syscall(GOTOXY,0,19);
				printf("lambda (V)");
				syscall(GOTOXY,5,13);
				getsn_vt(buf,13,pvt);
				mos->lambda=atof(buf);
				break;

			case 19: return;
			}
			break;
		}
	}
}

float idv(mos_param *mos,float vgs, float vds)
{
	float id;
	if (mos->tipo) {
	    if(vgs>mos->vto-1e-6) id=0;
	    else if (vds<(vgs-mos->vto)/mos->n) {
	    	id=-mos->beta/2./mos->n*(vgs-mos->vto)*(vgs-mos->vto);
	    } else {
	    	id=-mos->beta*(vgs-mos->vto-mos->n/2.*vds)*vds;
	    }
	    id*=(1-mos->lambda*vds);
	}else {
	    if (vgs<mos->vto) id=0;
	    else if (vds>(vgs-mos->vto)/mos->n) {
		id=mos->beta/2./mos->n*(vgs-mos->vto)*(vgs-mos->vto);
	    } else {
		id=mos->beta*(vgs-mos->vto-mos->n/2.*vds)*vds;
	    }
	    id*=(1+mos->lambda*vds);
	}
	return id;
}

float solve_vgs(mos_param *mos,float vds,float id)
{
	float vgs,dvgs,it;
	int i;
	if (mos->tipo) {vgs=-5; dvgs=5;} else { vgs=5; dvgs=5; }
	for (i=0;i<16;i++) {
		it=idv(mos,vgs,vds);
		if (it>id) vgs-=dvgs; else vgs+=dvgs;
		dvgs*=0.5;
	}
	return vgs;
}

void maxi_adj(float *maxi, int *n)
{
	float mult;
	const int max[9]={2,3,4,5,6,8,8,10,10};
	const int nd[9]= {4,3,4,5,3,4,4,5,5};
	int i;
	
	if (*maxi==0.0) {*maxi=1.0; return;}
	mult=1;
	if (*maxi>10) while (*maxi>10) {mult*=10; *maxi/=10;}
	if (*maxi<1) while (*maxi<1) {mult/=10; *maxi*=10;}
	
	i=*maxi-1;
	*maxi=max[i]*mult; *n=nd[i];
}

void ivds(vt *pvt,mos_param *mos)
{
	int i,j,nd,ev,x,y,x0,y0,nc,fgr;
	float vds,vds0,vgs,vgs0,vgs1,id,id0,imax,sy;
	char buf[16];
	
	if (mos->tipo) {
		vgs0=-1.0; vgs1=-5.0;
		vds0=-5;
	} else {
		vgs0=1.0; vgs1=5.0;
		vds0=5.0;
	} 
	nc=5;
	id0=idv(mos,vgs1,vds0);
	imax=fabs(id0);
	maxi_adj(&imax,&nd);

	fgr=1;
	for(;;) {
		if (fgr) {
		    fgr=0;
		    syscall(CLS);
		    
		    j=112/nd;			// Etiquetas eje Y
		    for (i=y=0;i<=nd;i++,y+=j) {
		    	y0=y>>3; if (y0>13) y0=13;
		    	syscall(GOTOXY,0,y0);
		    	id=(mos->tipo)? -i*imax/nd: (nd-i)*imax/nd;
		    	id*=1.000001e6;
		    	printf("%3f",id);
		    }
		    syscall(FILLED_RECTANGLE,32,0,159,112,0);
		    for (i=0;i<128;i++) {	// Dibujamos zona lineal
			x=32+i;
			vds=(mos->tipo)? -(127-i)*5.0/128 : i*5.0/128.;
			id=idv(mos,mos->n*vds+mos->vto,vds);
			if (fabs(id)>imax) continue;
			y=(mos->tipo)?-112*id/imax : 112-(112*id/imax+.5);
			if (mos->tipo) syscall(VLINE,x,y,112,1);
			else syscall(VLINE,x,0,y,1);
		    }

		    for (i=y=0;i<=nd;i++,y+=j) {	// Divisiones eje Y
		    	syscall(HLINE,32,159,y,2);
		    }

		    // Divisiones eje X
		    for (i=0,vds=0;i<5;i++,vds+=25.6){
			syscall(VLINE,32+(int)vds,0,112,2);
		    }
		    syscall(RECTANGLE,32,0,159,111,3);
		    syscall(GOTOXY,4,14);
		    if (mos->tipo) printf("-5 -4 -3 -2 -1 0");
		    else printf("0  1  2  3  4  5");
		    syscall(GOTOXY,0,19); printf("<<");
		    syscall(HLINE,0,159,159-11,3);
		    syscall(GOTOXY,0,15);
		    printf("VGS=%6f V\n",vgs1);
		    printf("VDS=%6f V\n",vds0);
		    printf("ID =%6f A\n",idv(mos,vgs1,vds0)*1e6);
		}
		//Dibujamos las curvas
		for (j=0;j<nc;j++) {
		    if (nc>2) vgs=vgs0+j*(vgs1-vgs0)/(nc-1);
		    else vgs=vgs0;
		    x0=32; y0=112;
		    for (i=0;i<128;i++) {
			x=32+i;
			vds=(mos->tipo)? -(127-i)*5.0/128. : i*5.0/128.;
			id=idv(mos,vgs,vds);
			y=(mos->tipo)? -112*id/imax+.5 : 112-(112*id/imax+.5);
			if (y>111) y=111 ;
			syscall(LINE,x0,y0,x,y,3);
			x0=x;y0=y;
		    }
		}
		for (;;) {
		    ev=syscall(VT_GET_EVENT);
		    if (ev==EV_KEYBOARD) syscall(VT_GET_EVENT);
		    if (ev==EV_LCD_TAP_PRESS) {
			x=syscall(VT_GET_EVENT);
			y=syscall(VT_GET_EVENT);
			if (x>=32 && x<160 && y>=0 && y<=112) {
				// Se ha picado en el dibujo.
				if (mos->tipo) {
				    id0=-y*imax/112;
				    vds0=-(159-x)*5.0/128;
				} else {
				    id0=(112-y)*imax/112;
				    vds0=(x-32)*5.0/128;
				}
				vgs0=vgs1=solve_vgs(mos,vds0,id0);
				syscall(GOTOXY,0,15);
				printf("VGS=%6f V\n",vgs0);
				printf("VDS=%6f V\n",vds0);
				printf("ID =%6f A\n",id0*1e6);
				nc=1;
				break;
			} else {
				y>>=3;
				if (y==15) {
					syscall(FILLED_RECTANGLE,32,15*8,159,15*8+7,0);
					syscall(GOTOXY,4,15);
					getsn_vt(buf,15,pvt);
					vgs0=vgs1=atof(buf);
					id0=idv(mos,vgs0,vds0);
					syscall(GOTOXY,0,15);
					printf("VGS=%6f V\n",vgs0);
					printf("VDS=%6f V\n",vds0);
					printf("ID =%6f A\n",id0*1e6);
					nc=1;
					break;
				}
				if (y==16) {
					syscall(FILLED_RECTANGLE,32,16*8,159,16*8+7,0);
					syscall(GOTOXY,4,16);
					getsn_vt(buf,15,pvt);
					vds0=atof(buf);
					vgs0=vgs1=solve_vgs(mos,vds0,id0);
					syscall(GOTOXY,0,15);
					printf("VGS=%6f V\n",vgs0);
					printf("VDS=%6f V\n",vds0);
					printf("ID =%6f A\n",id0*1e6);
					nc=1;
					break;
				}
				if (y==17) {
					syscall(FILLED_RECTANGLE,32,17*8,159,17*8+7,0);
					syscall(GOTOXY,4,17);
					getsn_vt(buf,15,pvt);
					id0=atof(buf)*1e-6;
					vgs0=vgs1=solve_vgs(mos,vds0,id0);
					syscall(GOTOXY,0,15);
					printf("VGS=%6f V\n",vgs0);
					printf("VDS=%6f V\n",vds0);
					printf("ID =%6f A\n",id0*1e6);
					imax=fabs(idv(mos,vgs0,(mos->tipo)?-5.0:5.0));
					maxi_adj(&imax,&nd);
					fgr=1;
					nc=1;
					break;
				}
				if (y==19) return; 
			}
		    }
		}
	}
}

void ivgs(vt *pvt,mos_param *mos)
{
	int i,j,nd,ev,x,y,x0,y0,nc,fgr;
	float vds,vds0,vds1,vgs,vgs0,vgs1,id,id0,imax,sy;
	char buf[16];
	
	if (mos->tipo) {
		vds0=0.0; vds1=-5.0;
		vgs0=-5;
	} else {
		vds0=0.0; vds1=5.0;
		vgs0=5.0;
	} 
	nc=6;
	id0=idv(mos,vgs0,vds1);
	imax=fabs(id0);
	maxi_adj(&imax,&nd);

	fgr=1;
	for(;;) {
		if (fgr) {
		    fgr=0;
		    syscall(CLS);
		    
		    j=112/nd;			// Etiquetas eje Y
		    for (i=y=0;i<=nd;i++,y+=j) {
		    	y0=y>>3; if (y0>13) y0=13;
		    	syscall(GOTOXY,0,y0);
		    	id=(mos->tipo)? -i*imax/nd: (nd-i)*imax/nd;
		    	id*=1.000001e6;
		    	printf("%3f",id);
		    }
		    syscall(FILLED_RECTANGLE,32,0,159,112,0);
		    // Dibujamos zona lineal
		    if(mos->tipo) {
		    	i=-mos->vto*128/5.0;
		    	for (;i<128;i++) {
		    		vgs=-i*5.0/128;
		    		vds=(vgs-mos->vto)/mos->n;
		    		id=idv(mos,vgs,vds);
		    		x=159-i;
		    		y=-112*id/imax;
		    		syscall(VLINE,x,0,y,1);
		    	}
		    } else {
		    	i=mos->vto*128/5.0;
		    	for (;i<128;i++) {
		    		vgs=i*5.0/128;
		    		vds=(vgs-mos->vto)/mos->n;
		    		id=idv(mos,vgs,vds);
		    		x=32+i;
		    		y=112-112*id/imax;
		    		syscall(VLINE,x,y,112,1);
		    	}
		    }

		    for (i=y=0;i<=nd;i++,y+=j) {	// Divisiones eje Y
		    	syscall(HLINE,32,159,y,2);
		    }

		    // Divisiones eje X
		    for (i=0,vds=0;i<5;i++,vds+=25.6){
			syscall(VLINE,32+(int)vds,0,112,2);
		    }
		    syscall(RECTANGLE,32,0,159,111,3);
		    syscall(GOTOXY,4,14);
		    if (mos->tipo) printf("-5 -4 -3 -2 -1 0");
		    else printf("0  1  2  3  4  5");
		    syscall(GOTOXY,0,19); printf("<<");
		    syscall(HLINE,0,159,159-11,3);
		}
		//Dibujamos las curvas
		for (j=0;j<nc;j++) {
		    if (nc>2) vds=vds0+j*(vds1-vds0)/(nc-1);
		    else vds=vds0;
		    x0=32; y0=112;
		    for (i=0;i<128;i++) {
			x=32+i;
			vgs=(mos->tipo)? -(127-i)*5.0/128. : i*5.0/128.;
			id=idv(mos,vgs,vds);
			y=(mos->tipo)? -112*id/imax+.5 : 112-(112*id/imax+.5);
			if (y>111) y=111 ;
			syscall(LINE,x0,y0,x,y,3);
			x0=x;y0=y;
		    }
		}
		for (;;) {
		    ev=syscall(VT_GET_EVENT);
		    if (ev==EV_KEYBOARD) syscall(VT_GET_EVENT);
		    if (ev==EV_LCD_TAP_PRESS) {
			x=syscall(VT_GET_EVENT);
			y=syscall(VT_GET_EVENT)>>3;
			if (y==19) return; 
		    }
		}
	}
}

void mos()
{
	vt *pvt;
	mos_param mos[8];
	int i,ev,x,y,nt;
	
	pvt=(vt *)syscall(OPEN_VT,1);	// 4 grises
	if (!pvt) syscall(TASK_EXIT);
	syscall(CLS);
	syscall(VT_TO_FG);
	
	dibuja_seccion_mos(10,0);
	dibuja_frontal_mos(90,0);
	
	syscall(GOTOXY,3,10); printf("Transistor MOS");
	syscall(GOTOXY,2,12); printf("Jess Arias 2000");

	// Inicializamos la base de datos
	strcpy(mos[0].nombre,"DEF_N");
	mos[0].tipo=0;		//Canal N
	mos[0].tox=435;		//amgst.
	mos[0].vto=0.9;		//Volt
	mos[0].L=10;		//micras
	mos[0].W=20;		//micras
	mos[0].uo=500;		//cm2/Vs
	mos[0].nsub=3.3e15;	//cm-3
	deriva_param(&mos[0]);
	strcpy(mos[1].nombre,"DEF_P");
	mos[1].tipo=1;	//Canal P
	mos[1].tox=435;	//amgst.
	mos[1].vto=-0.9;	//Volt
	mos[1].L=10;		//micras
	mos[1].W=20;		//micras
	mos[1].uo=180;	//cm2/Vs
	mos[1].nsub=1e16;	//cm-3
	deriva_param(&mos[1]);
	
	// AMS 0.6 micras
	strcpy(mos[2].nombre,"AMS 0.6 N");
	mos[2].tipo=0;		//Canal N
	mos[2].tox=125;		//amgst.
	mos[2].vto=0.85;	//Volt
	mos[2].L=0.6;		//micras
	mos[2].W=0.8;		//micras
	mos[2].uo=430;		//cm2/Vs
	mos[2].nsub=1.45e17;	//cm-3
	deriva_param(&mos[2]);
	strcpy(mos[3].nombre,"AMS 0.6 P");
	mos[3].tipo=1;		//Canal P
	mos[3].tox=125;		//amgst.
	mos[3].vto=-0.85;	//Volt
	mos[3].L=0.6;		//micras
	mos[3].W=0.8;		//micras
	mos[3].uo=145;		//cm2/Vs
	mos[3].nsub=5.2e16;	//cm-3
	deriva_param(&mos[3]);
	
	// AMS 0.35 micras
	strcpy(mos[4].nombre,"AMS 0.35 N");
	mos[4].tipo=0;		//Canal N
	mos[4].tox=75;		//amgst.
	mos[4].vto=0.52;	//Volt
	mos[4].L=0.35;		//micras
	mos[4].W=0.6;		//micras
	mos[4].uo=385;		//cm2/Vs
	mos[4].nsub=2e17;	//cm-3
	deriva_param(&mos[4]);
	strcpy(mos[5].nombre,"AMS 0.35 P");
	mos[5].tipo=1;		//Canal P
	mos[5].tox=75;		//amgst.
	mos[5].vto=-0.65;	//Volt
	mos[5].L=0.35;		//micras
	mos[5].W=0.6;		//micras
	mos[5].uo=130;		//cm2/Vs
	mos[5].nsub=1.1e17;	//cm-3
	deriva_param(&mos[5]);

	strcpy(mos[6].nombre,"DEF_N");
	mos[6].tipo=0;		//Canal N
	mos[6].tox=435;		//amgst.
	mos[6].vto=0.9;		//Volt
	mos[6].L=10;		//micras
	mos[6].W=20;		//micras
	mos[6].uo=500;		//cm2/Vs
	mos[6].nsub=3.3e15;	//cm-3
	deriva_param(&mos[6]);
	strcpy(mos[7].nombre,"DEF_P");
	mos[7].tipo=1;	//Canal P
	mos[7].tox=435;	//amgst.
	mos[7].vto=-0.9;	//Volt
	mos[7].L=10;		//micras
	mos[7].W=20;		//micras
	mos[7].uo=180;	//cm2/Vs
	mos[7].nsub=1e16;	//cm-3
	deriva_param(&mos[7]);
	
	nt=0;
	
	for(;;) {
		syscall(FILLED_RECTANGLE,0,159-12,159,159,0);
		syscall(GOTOXY,0,19); printf("() DB PAR IVDS IVGS");
		syscall(HLINE,0,159,160-12,3);
		ev=syscall(VT_GET_EVENT);
		switch(ev) {
		case EV_KEYBOARD:
			syscall(VT_GET_EVENT);
			break;
		case EV_LCD_TAP_PRESS:
			x=syscall(VT_GET_EVENT);
			y=syscall(VT_GET_EVENT);
			if (y>160-12) {
				i=x/40;
				if (i==0) {if (x>20) i=1;} else i++;
				switch(i){
				case 0:	//<<
					//syscall(TASK_EXIT);
					syscall(CLS);
					dibuja_seccion_mos(10,0);
					dibuja_frontal_mos(90,0); 
					syscall(GOTOXY,3,10);
					printf("Transistor MOS");
					syscall(GOTOXY,2,12);
					printf("Jess Arias 2000");
					break;
				case 1: syscall(CLS);
					for (i=0;i<8;i++) {
						printf((i==nt)?"->":"  ");
						printf("%s\n",mos[i].nombre);
					}
					for (;;) {
						ev=syscall(VT_GET_EVENT);
						if (ev==EV_KEYBOARD)
							syscall(VT_GET_EVENT);
						if (ev==EV_LCD_TAP_PRESS){
							x=syscall(VT_GET_EVENT);
							y=syscall(VT_GET_EVENT);
							y>>=3;
							if (y<8) nt=y;
							break;
						}
					}
					syscall(CLS);
					syscall(GOTOXY,4,8); printf("Transistor:");
					syscall(GOTOXY,4,9); printf(mos[nt].nombre);
					
					break;
				case 2:	get_param(pvt,&mos[nt]); break;
				case 3: ivds(pvt,&mos[nt]); break;
				case 4: ivgs(pvt,&mos[nt]); break;
				}
				
			}
			break;
		}
	}
}

#define NSTACK 2048

main()
{
    register char *p;
    
    //necesitamos una pila ms grande por la rutina recursiva
    //if (!(p=(char *)syscall(KMALLOC,NSTACK))) syscall(TASK_EXIT);
    //asm volatile("movea.l %0,%%sp"::"a"(&p[NSTACK]));

    mos();
}
