#include <math.h>

#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "../keyboard.h"
#include "../file.h"
#include "../lang.h"
#include "ulib.h"

void test_lissa()
{
	vt *pvt;
	
	double a,x,y;
	int i,ev;
	
	pvt=(vt *)syscall(OPEN_VT,0);
	syscall(VT_TO_FG);
	syscall(CLS);
	
	syscall(CURSOR_OFF);

	for (i=2;i<160;i+=4) {
		syscall(VLINE,i,0,160,1);
		syscall(HLINE,0,160,i,1);
	}

	for (i=1;i<=360*2;i++) {
		a=i*3.141592653/180.;
		x=80+76*sin(a);
		y=80-76*sin(1.5*a);
		syscall(FILLED_CIRCLE,(int)x,(int)y,2,1);
	}
	do {
		ev=syscall(VT_GET_EVENT);
		switch(ev) {
			case EV_KEYBOARD:
				syscall(VT_GET_EVENT);
				break;
			case EV_LCD_TAP_PRESS:
				syscall(VT_GET_EVENT);
				syscall(VT_GET_EVENT);
				break;
		}
	}while (ev!=EV_LCD_TAP_PRESS);
	syscall(TASK_EXIT);
}

void test_sound()
{
	const int vol[5]={1,2,4,8,15};
	unsigned char i,j;
	for (j=0;j<4;j++){
	    syscall(SOUND,j*500+2500,vol[0]);
	    for (i=1;i<5;i++) {
		syscall(TASK_SLEEP,8);
		syscall(SOUND_VOL,vol[i]);
	    }
	    syscall(TASK_SLEEP,8);
	}
	syscall(SOUND_OFF);
	syscall(TASK_EXIT);
}

char getch_0()
{
	for (;;){
		switch(syscall(VT_GET_EVENT)) {
			case EV_KEYBOARD:
				return syscall(VT_GET_EVENT);
				break;
			case EV_LCD_TAP_PRESS:
				syscall(VT_GET_EVENT);
				syscall(VT_GET_EVENT);
				syscall(TASK_EXIT);
				break;
		}
	}
}

#define NL 120
#define NF 11
#define NRET 5

void album_fotos()
{
	vt *pvt;
	file_header *pf;
	char *sbase,*pdata;
	
	int modo,ix,k,ok,nf;
	
	pvt=(vt *)syscall(OPEN_VT,0);
	syscall(VT_TO_FG);
	syscall(CLS);

	printf("Select a graph");

	if((ix=syscall(FILE_SEL_INT,GRAPHIC,0,0))==-1) syscall(TASK_EXIT);
	nf=syscall(FILE_GET_NFILES,GRAPHIC,0);
	pf=(file_header *)syscall(FILE_SEL_IX,GRAPHIC,0,ix);
	for(;;) {
		syscall(CLOSE_MY_VT); 
		switch(pf->subtype){
		case SCREEN_DUMP_1BPP:	modo=0; ok=1; break;
		case SCREEN_DUMP_2BPP:  modo=1; ok=1; break;
		case SCREEN_DUMP_4BPP:	modo=2; ok=1; break;
		default:	modo=0; ok=0; break;
		}
		pvt=(vt *)syscall(OPEN_VT,modo);
		syscall(VT_TO_FG);
		syscall(CURSOR_OFF);
		sbase=(char *)syscall(VT_GET_SCREEN_BASE);
		if (ok) memcpy(sbase,(char *)((int)pf+sizeof(file_header)),pf->size);
		else {
			syscall(CLS); syscall(GOTOXY,0,9);
			printf(MSG_FILE_ACTION_NOTSUP);
		}
		k=getch_0();
		if (k==K_U) if(ix) ix--;
		if (k==K_D) if(ix<nf-1) ix++;
		pf=(file_header *)syscall(FILE_SEL_IX,GRAPHIC,0,ix);
	}

}


/*----------------------------------------------------------------------------*/

