#include "init.h"
#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "ulib.h"

#define NMINAS 20

/***************************************************************************/
int rand()
{
  static unsigned long r=0x1234567;
  r=r* 1103515245 + 12345;
  return (r>>16)&0x7fff;
}


/***************************************************************************/

#define BORDER 3

void boton(int x,int y,int dx,int dy,int ud)
{
	int i,c1,c2;
	syscall(FILLED_RECTANGLE,x+BORDER,y+BORDER,x+dx-BORDER,y+dy-BORDER,0);
	if (ud) {c1=2; c2=3;} else {c1=3; c2=2;};
	for (i=0;i<BORDER;i++) {
		syscall(HLINE,x+i,x+dx-i,y+i,c1);
		syscall(VLINE,x+i,y+i,y+dy-i,c1);
		syscall(HLINE,x+i,x+dx-i,y+dy-i,c2);
		syscall(VLINE,x+dx-i,y+i,y+dy-i,c2);
	}
}
/***************************************************************************/


#define DASH 4
#define DCOLOR 3

void digito(int x, int y, int n)
{
	char *p;

	char *numeros[10]={
	"0ESSWNN",	//0
	"1SS",		//1
	"0ESWSE",	//2
	"0ESWESW",	//3
	"0SENSS",	//4
	"1WSESW",	//5
	"1WSSENW",	//6
	"0ESS",		//7
	"0SSENWENW",	//8
	"2NNWSE"	//9
	};
	
	p=(char *)numeros[n];
	switch(*p++) {
	case '0':	x-=DASH/2; y-=DASH; break;
	case '1':	x+=DASH/2; y-=DASH; break;
	case '2':	x+=DASH/2; y+=DASH; break;
	}
	while (*p) {
		switch(*p++) {
		case 'N': syscall(VLINE,x,y-DASH,y,DCOLOR);
			  y-=DASH; break;
		case 'S': syscall(VLINE,x,y,y+DASH,DCOLOR);
			  y+=DASH; break;
		case 'E': syscall(HLINE,x,x+DASH,y,DCOLOR);
			  x+=DASH; break;
		case 'W': syscall(HLINE,x-DASH,x,y,DCOLOR);
			  x-=DASH; break;
		}
	}	
}

/**************************************************************************/

char mapa[10][10];
short nmin;

void marca(int i,int j)
{
	int n;
	if ((mapa[i][j]&0x40)!=0) return;
	if ((mapa[i][j]&0x80)==0) {
		n=3;
		nmin--;
	} else {
		n=0;
		nmin++;
	}
	mapa[i][j]^=0x80;
	//syscall(FILLED_CIRCLE,(i<<4)+7,(j<<4)+7,4,n);
	syscall(RECTANGLE,(i<<4)+BORDER+1,(j<<4)+BORDER+1,
	                         (i<<4)+14-BORDER,(j<<4)+14-BORDER,n);
	syscall(RECTANGLE,(i<<4)+BORDER+2,(j<<4)+BORDER+2,
	                         (i<<4)+13-BORDER,(j<<4)+13-BORDER,n);
}

int test(i,j)
{
	if (i<0||i>9) return(0);
	if (j<0||j>9) return(0);
	return(mapa[i][j]&1);
}

int pisa(int i,int j)
{
	int c,ii,jj;

	if (i<0||i>9) return(0);
	if (j<0||j>9) return(0);
	//if ((mapa[i][j]&0x80)!=0) return(0);
	if ((mapa[i][j]&0x40)!=0) return(0);

	mapa[i][j]|=0x40;
	syscall(FILLED_RECTANGLE,i<<4,j<<4,(i<<4)+15,(j<<4)+15,0);
	if (test(i,j)!=0) {
		//syscall(FILLED_RECTANGLE,i<<4,j<<4,(i<<4)+15,(j<<4)+15,3);
		//boton(i<<4,j<<4,15,15,0);
		for (ii=0;ii<10;ii++)
			for (jj=0;jj<10;jj++) {
				if (test(ii,jj)!=0) {
				  //syscall(FILLED_RECTANGLE,ii<<4,jj<<4,(ii<<4)+15,(jj<<4)+15,3);
				  boton(ii<<4,jj<<4,15,15,0);
				  syscall(FILLED_CIRCLE,(ii<<4)+7,(jj<<4)+7,4,3);
				  syscall(FILLED_CIRCLE,(ii<<4)+6,(jj<<4)+6,1,0);
				}
				if ((mapa[ii][jj]&0xC1)==0x80) {
				  syscall(LINE,(ii<<4),(jj<<4),(ii<<4)+15,(jj<<4)+15,3);
				  syscall(LINE,(ii<<4)+15,(jj<<4),(ii<<4),(jj<<4)+15,3);
				}
			}
		return 1;
	}
	else {
		c=test(i-1,j-1)+test(i-1,j)+test(i-1,j+1)+test(i,j-1)+test(i,j+1)+test(i+1,j-1)+test(i+1,j)+test(i+1,j+1);
		if (c==0) {
			pisa(i-1,j-1); pisa(i-1,j); pisa(i-1,j+1); pisa(i,j-1); pisa(i,j+1); pisa(i+1,j-1); pisa(i+1,j); pisa(i+1,j+1);
		} else {
			digito((i<<4)+7,(j<<4)+7,c);
		}
		
		for (i=ii=0;i<10;i++)
		    for (j=0;j<10;j++) if (mapa[i][j]&0x40) ii++;
		if (ii+NMINAS==100) return 2;
	}
	return 0;
}

void minas()
{
    vt *pvt;
    int i,j,i0,j0,k;
    unsigned int tsc,tsc0;

    pvt=(vt *)syscall(OPEN_VT,1);
    if (!pvt) syscall(TASK_EXIT);
    syscall(CLS);
    syscall(VT_TO_FG);
    syscall(CURSOR_OFF);

    i0=j0=tsc0=0;
    
    for(;;){
	for (i=0;i<10;i++)
		for (j=0;j<10;j++) {
			boton(i<<4,j<<4,15,15,1);
			mapa[i][j]=0;
		}

	for (k=0;k<NMINAS;k++) {
	  do {
		i=(rand()>>8)%10;
		j=(rand()>>8)%10;
	  } while (test(i,j)!=0);
	  mapa[i][j]=1;
	}
	nmin=NMINAS;

	for (;;){
		k=syscall(VT_GET_EVENT);
		if (k==EV_KEYBOARD){
			syscall(VT_GET_EVENT);
		} else if (k==EV_LCD_TAP_PRESS) {
			i=syscall(VT_GET_EVENT);
			j=syscall(VT_GET_EVENT);
			tsc=syscall(RDTSC);
			if (i<0 || i>159) continue;
			if (j<0 || j>159) continue;
			i>>=4; j>>=4;
			if (tsc-tsc0 < 32 && i0==i && j0==j){
			  if (k=pisa(i,j)){
			    if (k==2) {
			        boton(6*8-8,9*8-8,8*8+14,8+14,1);
			    	syscall(GOTOXY,6,9);
			    	printf("MUY BIEN\n");
			    	syscall(CURSOR_OFF,0);
			    }
			    while(syscall(VT_GET_EVENT)!=EV_LCD_TAP_PRESS);
			    break;
			  }
			}else marca(i,j);
			tsc0=tsc; i0=i; j0=j;
		}
	}
    }
}

#define NSTACK 0x2000

main()
{
    register char *p;
    
    //necesitamos una pila ms grande por la rutina recursiva
    //if (!(p=(char *)syscall(KMALLOC,NSTACK))) syscall(TASK_EXIT);
    //asm volatile("movea.l %0,%%sp"::"a"(&p[NSTACK]));

    minas();
}
