#include "init.h"

#include <math.h>

#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "../keyboard.h"
#include "../file.h"
#include "ulib.h"

char getch_0()
{
	for (;;){
		switch(syscall(VT_GET_EVENT)) {
			case EV_KEYBOARD:
				return syscall(VT_GET_EVENT);
				break;
			case EV_LCD_TAP_PRESS:
				syscall(VT_GET_EVENT);
				syscall(VT_GET_EVENT);
				syscall(TASK_EXIT);
				break;
		}
	}
}


double a,x,y;
int i,ev;

main()
{
	vt *pvt;
	
	
	pvt=(vt *)syscall(OPEN_VT,0);
	syscall(VT_TO_FG);
	syscall(CLS);
	
	syscall(CURSOR_OFF);

	for (i=2;i<160;i+=4) {
		syscall(VLINE,i,0,160,1);
		syscall(HLINE,0,160,i,1);
	}

	for (i=1;i<=360*2;i++) {
		a=i*3.141592653/180.;
		x=80+76*sin(a);
		y=80-76*sin(1.5*a);
		syscall(FILLED_CIRCLE,(int)x,(int)y,2,1);
	}
	do {
		ev=syscall(VT_GET_EVENT);
		switch(ev) {
			case EV_KEYBOARD:
				syscall(VT_GET_EVENT);
				break;
			case EV_LCD_TAP_PRESS:
				syscall(VT_GET_EVENT);
				syscall(VT_GET_EVENT);
				break;
		}
	}while (ev!=EV_LCD_TAP_PRESS);
	syscall(TASK_EXIT);
}
