#define  DCTSIZE 8
#define  DCTSIZE2 64

#define MPY(a,b) (((short)(a) * (short)(b))>>8)
#define FIX(a) ((int)(256*(a)+0.5))

/*
 * Perform inverse DCT on one block of coefficients.
 */


void iidct (short *inptr, short *outptr)
{
  short tmp0, tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7;
  short tmp10, tmp11, tmp12, tmp13;
  short z5, z10, z11, z12, z13;
  short * wsptr;
  int ctr;
  short workspace[DCTSIZE2]; /* buffers data between passes */

  /* Pass 1: process columns from input, store into work array. */

  wsptr = workspace;
  for (ctr = DCTSIZE; ctr > 0; ctr--) {

    /* Even part */

    tmp0 = inptr[DCTSIZE*0]<<8;
    tmp1 = inptr[DCTSIZE*2]<<8;
    tmp2 = inptr[DCTSIZE*4]<<8;
    tmp3 = inptr[DCTSIZE*6]<<8;

    tmp10 = tmp0 + tmp2;	/* phase 3 */
    tmp11 = tmp0 - tmp2;

    tmp13 = tmp1 + tmp3;	/* phases 5-3 */
    tmp12 = MPY((tmp1 - tmp3),362) - tmp13; /* 2*c4 */

    tmp0 = tmp10 + tmp13;	/* phase 2 */
    tmp3 = tmp10 - tmp13;
    tmp1 = tmp11 + tmp12;
    tmp2 = tmp11 - tmp12;

    /* Odd part */

    tmp4 = inptr[DCTSIZE*1]<<8;
    tmp5 = inptr[DCTSIZE*3]<<8;
    tmp6 = inptr[DCTSIZE*5]<<8;
    tmp7 = inptr[DCTSIZE*7]<<8;

    z13 = tmp6 + tmp5;		/* phase 6 */
    z10 = tmp6 - tmp5;
    z11 = tmp4 + tmp7;
    z12 = tmp4 - tmp7;

    tmp7 = z11 + z13;		/* phase 5 */
    tmp11 =  MPY((z11 - z13),362); /* 2*c4 */

    z5 =     MPY((z10 + z12),473); /* 2*c2 */
    tmp10 =  MPY(z12,277)-z5; /* 2*(c2-c6) */
    tmp12 = -MPY(z10,669)+z5; /* -2*(c2+c6) */

    tmp6 = tmp12 - tmp7;	/* phase 2 */
    tmp5 = tmp11 - tmp6;
    tmp4 = tmp10 + tmp5;

    wsptr[DCTSIZE*0] = tmp0 + tmp7;
    wsptr[DCTSIZE*7] = tmp0 - tmp7;
    wsptr[DCTSIZE*1] = tmp1 + tmp6;
    wsptr[DCTSIZE*6] = tmp1 - tmp6;
    wsptr[DCTSIZE*2] = tmp2 + tmp5;
    wsptr[DCTSIZE*5] = tmp2 - tmp5;
    wsptr[DCTSIZE*4] = tmp3 + tmp4;
    wsptr[DCTSIZE*3] = tmp3 - tmp4;

    inptr++;			/* advance pointers to next column */
    //quantptr++;
    wsptr++;
  }

  /* Pass 2: process rows from work array, store into output array. */
  /* Note that we must descale the results by a factor of 8 == 2**3. */

  wsptr = workspace;
  for (ctr = 0; ctr < DCTSIZE; ctr++) {

    /* Even part */

    tmp10 = wsptr[0] + wsptr[4];
    tmp11 = wsptr[0] - wsptr[4];

    tmp13 = wsptr[2] + wsptr[6];
    tmp12 = MPY((wsptr[2] - wsptr[6]),362) - tmp13;

    tmp0 = tmp10 + tmp13;
    tmp3 = tmp10 - tmp13;
    tmp1 = tmp11 + tmp12;
    tmp2 = tmp11 - tmp12;

    /* Odd part */

    z13 = wsptr[5] + wsptr[3];
    z10 = wsptr[5] - wsptr[3];
    z11 = wsptr[1] + wsptr[7];
    z12 = wsptr[1] - wsptr[7];

    tmp7 = z11 + z13;
    tmp11 =  MPY((z11 - z13),362);

    z5 =     MPY((z10 + z12),473); /* 2*c2 */
    tmp10 =  MPY(z12,277)-z5; /* 2*(c2-c6) */
    tmp12 = -MPY(z10,669)+z5; /* -2*(c2+c6) */

    tmp6 = tmp12 - tmp7;
    tmp5 = tmp11 - tmp6;
    tmp4 = tmp10 + tmp5;

    /* Final output stage: scale down by a factor of 8 and range-limit */

    outptr[0] = (tmp0 + tmp7)>>7;
    outptr[7] = (tmp0 - tmp7)>>7;
    outptr[1] = (tmp1 + tmp6)>>7;
    outptr[6] = (tmp1 - tmp6)>>7;
    outptr[2] = (tmp2 + tmp5)>>7;
    outptr[5] = (tmp2 - tmp5)>>7;
    outptr[4] = (tmp3 + tmp4)>>7;
    outptr[3] = (tmp3 - tmp4)>>7;

    wsptr += DCTSIZE;		/* advance pointer to next row */
    outptr += DCTSIZE;
  }
}

