#include "init.h"
#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "../keyboard.h"
#include "../file.h"
#include "ulib.h"

char mi_getch()
{
	for (;;){
		switch(syscall(VT_GET_EVENT)) {
			case EV_KEYBOARD:
				return syscall(VT_GET_EVENT);
				break;
			case EV_LCD_TAP_PRESS:
				syscall(VT_GET_EVENT);
				syscall(VT_GET_EVENT);
				syscall(TASK_EXIT);
				break;
		}
	}
}


void main()
{
	vt *pvt;
	file_header *pf;
	char *sbase,*pdata;
	
	int modo,ix,k,ok,nf;
	
	pvt=(vt *)syscall(OPEN_VT,0);
	syscall(VT_TO_FG);
	syscall(CLS);

	printf("Select a graph");

	if((ix=syscall(FILE_SEL_INT,GRAPHIC,0,0))==-1) syscall(TASK_EXIT);
	nf=syscall(FILE_GET_NFILES,GRAPHIC,0);
	pf=(file_header *)syscall(FILE_SEL_IX,GRAPHIC,0,ix);
	for(;;) {
		syscall(CLOSE_MY_VT); 
		switch(pf->subtype){
		case SCREEN_DUMP_1BPP:	modo=0; ok=1; break;
		case SCREEN_DUMP_2BPP:  modo=1; ok=1; break;
		case SCREEN_DUMP_4BPP:	modo=2; ok=1; break;
		default:	modo=0; ok=0; break;
		}
		pvt=(vt *)syscall(OPEN_VT,modo);
		syscall(VT_TO_FG);
		syscall(CURSOR_OFF);
		sbase=(char *)syscall(VT_GET_SCREEN_BASE);
		if (ok) memcpy(sbase,(char *)((int)pf+sizeof(file_header)),pf->size);
		else {
			syscall(CLS); syscall(GOTOXY,0,9);
			printf("Formato no soportado");
		}
		k=mi_getch();
		if (k==K_U) if(ix) ix--;
		if (k==K_D) if(ix<nf-1) ix++;
		pf=(file_header *)syscall(FILE_SEL_IX,GRAPHIC,0,ix);
	}

}

