#include "init.h"
#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "ulib.h"
#include "fix_fft.h"

#include "fix_fft.c"

void main()
{
	vt *pvt;
	int i,scale;
	long long t1,t0;
	short *sr,*si,*sp;

	pvt=(vt *)syscall(OPEN_VT,0);
	if (!pvt) syscall(TASK_EXIT);
	syscall(VT_TO_FG);
	
	sr=(short *)syscall(KMALLOC,2048);
	if(!sr) syscall(TASK_EXIT);
	si=(short *)syscall(KMALLOC,2048);
	if(!si) syscall(TASK_EXIT);
	sp=(short *)syscall(KMALLOC,1024);
	if(!sp) syscall(TASK_EXIT);

	syscall(CLS);
	printf("FFT speed test\n1024 samples.\n\n");

	for (i=0;i<1024;i++) {
		sr[i]=Sinewave[(i<<5)&1023];
		si[i]=0;
	}


	syscall(TASK_GET_TIME,&t0);
	window(sr,1024);
	syscall(TASK_GET_TIME,&t1);
	i=(int)((t1-t0)/2072);
	printf("Window: %d ms\n",i);
	
	syscall(TASK_GET_TIME,&t0);
	scale=fix_fft(sr,si,10,0);
	syscall(TASK_GET_TIME,&t1);
	i=(int)((t1-t0)/2072);
	printf("FFT:    %d ms\n",i);
	
	syscall(TASK_GET_TIME,&t0);
	fix_loud(sp,sr,si,512,scale);
	syscall(TASK_GET_TIME,&t1);
	i=(int)((t1-t0)/2072);
	printf("dB:     %d ms\n",i);

	syscall(TASK_GET_TIME,&t0);
	scale=fix_fft(sr,si,10,1);
	syscall(TASK_GET_TIME,&t1);
	i=(int)((t1-t0)/2072);
	printf("Inv FFT:%d ms\n",i);

	for (i=1;i<160;i++) {
		syscall(LINE,i-1,60-sp[i-1],i,60-sp[i],1);
		syscall(LINE,i-1,160-48-(sr[i-1]>>9),i,160-48-(sr[i]>>9),1);
	} 

	for(;;) {
		i=syscall(VT_GET_EVENT);
		switch(i) {
		case EV_LCD_TAP_PRESS:
			syscall(TASK_EXIT);
		case EV_KEYBOARD:
			i=syscall(VT_GET_EVENT);
		}
	}
}
