#include "init.h"
#include "../common.h"
#include "../syscall.h"
#include "../event.h"
#include "../file.h"
#include "ulib.h"

const unsigned char debcode[]=
#include "deb.hex"

#include "font_5x7.c"

#define FW 5
#define FH 7
#define EFH 7
#define FMASK 0xf8000000

#define NC (160/FW)
#define NR (160/EFH)

wrchar(char *base,int x,int y,unsigned char a)
{
	unsigned int i,j,dis,m,*pi;
	unsigned char *p,*pf;
	
	pf=(char *)&fontdata[FH*(unsigned int)a];
	
	i=x*FW;
	pi=(unsigned int *)&base[EFH*20*y+((i>>4)<<1)];
	dis=i&15;
	
	m=FMASK; m>>=dis;
	for (j=0;j<EFH;j++) {
		i=(*pf++); i<<=24-dis;
		*pi|=m; *pi^=m;
		*pi|=i;
		pi=&pi[5];
	}
}

int cx,cy;

void putc(char a)
{
	unsigned char *p,*p1,*base;
	
	base=(char *)syscall(VT_GET_SCREEN_BASE);
	
	switch(a) {
	case '\r':	cx=0; break;
	case '\n':	cy++; cx=0;
			if (cy==NR+1) {
				p=base; p1=&base[20*EFH];
				while(p1<&base[3200]) *p++=*p1++;
				while(p<&base[3200]) *p++=0;
				cy--;
			}
			break;
	case '\t':	cx+=8; cx&=~7;
			break;
			
	default:	if (cx<NC) wrchar(base,cx++,cy,a);
			break;
	}
}

main()
{
	vt *pvt;
	int i;
	char *p;
	char *(*fp)(char *,void (*)(char));
	file_header *pf;
	
	pvt=(vt *)syscall(OPEN_VT,0);
	syscall(VT_TO_FG);
	syscall(CLS);
	printf("Disassemble:");
	i=syscall(FILE_SEL_INT,BINARY_CODE,MC_PIC,0);
	if (i<0) syscall(TASK_EXIT);
	pf=(file_header *)syscall(FILE_SEL_IX,BINARY_CODE,MC_PIC,i);
	
	syscall(CLS);
	syscall(CURSOR_OFF);

	cx=cy=0;
	
	p=(char *)++pf;
	fp=(char *(*)())debcode;
	for (i=0;i<NR;i++) p=fp(p,putc);

	for(;;) {
		i=syscall(VT_GET_EVENT);
		switch(i) {
		case EV_LCD_TAP_PRESS:
				syscall(TASK_EXIT);
		case EV_KEYBOARD:
				syscall(VT_GET_EVENT);
				p=fp(p,putc);
				break;
		}
	}
}
