#include "init.h"
#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "../keyboard.h"
#include "../file.h"
#include "ulib.h"


char mi_getch()
{
	for (;;){
		switch(syscall(VT_GET_EVENT)) {
			case EV_KEYBOARD:
				return syscall(VT_GET_EVENT);
				break;
			case EV_LCD_TAP_PRESS:
				syscall(VT_GET_EVENT);
				syscall(VT_GET_EVENT);
				syscall(TASK_EXIT);
				break;
		}
	}
}

void main()
{
	vt *pvt;
	file_header *pf;
	unsigned char *panta;
        void (*showimage)(unsigned char *,unsigned char *,int,int);

	int modo,ix,k,ok,ox,oy,nf;

	pvt=(vt *)syscall(OPEN_VT,2);
	syscall(VT_TO_FG);
        syscall(CURSOR_OFF);
        syscall(CLS);

        panta=(char *)syscall(VT_GET_SCREEN_BASE);
        showimage=(void (*)(unsigned char *,unsigned char *,int,int))syscall(ZIP_GET_DCT_ADDRESS);
        ox=oy=0;

        printf("select graph");

	if((ix=syscall(FILE_SEL_INT,GRAPHIC,WINDOW_ZIP,0))==-1) syscall(TASK_EXIT);
	nf=syscall(FILE_GET_NFILES,GRAPHIC,WINDOW_ZIP);
	pf=(file_header *)syscall(FILE_SEL_IX,GRAPHIC,WINDOW_ZIP,ix);
	for(;;) {
                syscall(CLS); syscall(CURSOR_OFF);
		showimage (panta,(char *)((int)pf+sizeof(file_header)),ox,oy);
                k=mi_getch();
                switch(k) {
                case K_U: if (oy>0) oy--; break;
                case K_D: oy++; break;
                case K_L: if (ox>0) ox--; break;
                case K_R: ox++; break;
                case ' ': if(ix<nf-1) ix++;
                          pf=(file_header *)syscall(FILE_SEL_IX,GRAPHIC,WINDOW_ZIP,ix);
                          ox=oy=0; break;
                case '\n': if(ix) ix--;
                           pf=(file_header *)syscall(FILE_SEL_IX,GRAPHIC,WINDOW_ZIP,ix);
                           ox=oy=0; break;
                }
	}
}

