#include "init.h"
#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "../keyboard.h"
#include "../file.h"
#include "ulib.h"

#include "iidct.c"

unsigned char *panta;

unsigned char bitbuf,*cmpbuf;
int cbit;

extern inline int inbit()
{
        int i;
        if (cbit==0){
                bitbuf=*cmpbuf++;
                cbit=8;
        }
        i=bitbuf>>7;
        bitbuf<<=1; cbit--;
        return i;
}

int inbits(int nb)
{
        int i=0;
        for (;nb;nb--) {
                i<<=1;
                if (inbit()) i++;
        }
        return i;
}

int incoef()
{
        int i,n;
        static int nzeros=0;

        if (nzeros) {
                nzeros--;
                return 0;
        }
        n=inbit();
        if (n==0) return n;
        n=inbits(3);
        if(n!=0 && n!=4) {
                if (n<4) return n;
                return n-8;
        }
        if (n==4) {
                n=inbits(6);
                if (n<4) {
                        nzeros=48+8*n;
                        nzeros--; return 0;
                }
                return -n;
        }
        n=inbits(6);
        if (n<4) {
                nzeros=16+8*n;
                nzeros--; return 0;
        }
        return n;
}

void showimage (char *pfile,int ox,int oy)
{
	int i,is,js,j,k,n,nx,ny;
        short subf[64],subo[64];
        unsigned char *p;
        const unsigned char swfr[64]={
        0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,
        48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,
        22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,
        55,62,63};


        if (pfile[0]!='D' || pfile[1]!='C' || pfile[2]!='T' || pfile[3]!=1) {
                //printf("Bad file\n");
                //exit(0);
                return;
        }
        nx=pfile[4];     // n subimages X
        ny=pfile[5];     // n subimages Y

        cmpbuf=&pfile[6]; cbit=0;

        for (is=0;is<ny;is++) {
           for (js=0;js<nx;js++) {
                for (i=0;i<64;i++) {
                        subf[(js&1)?63-swfr[i]:swfr[i]]=incoef();
                }
                if (is<oy || is>oy+19) continue;
                if (js<ox || js>ox+19) continue;
                subf[53]+=1; // Dithering for 16 colors
                iidct(subf,subo);
                p=&panta[(is-oy)*640+((js-ox)<<2)];
                for (k=i=0;i<8;i++) {
                    for (j=0;j<4;j++) {
                        n=subo[k++]+128;
                        if (n<0) n=0; if (n>255) n=255;
                        *p=n&0xf0;
                        n=subo[k++]+128;
                        if (n<0) n=0; if (n>255) n=255;
                        *p|=n>>4;
                        *p++^=0xff;
                    }
                    p=&p[76];
                }
           }
        }
}



char mi_getch()
{
	for (;;){
		switch(syscall(VT_GET_EVENT)) {
			case EV_KEYBOARD:
				return syscall(VT_GET_EVENT);
				break;
			case EV_LCD_TAP_PRESS:
				syscall(VT_GET_EVENT);
				syscall(VT_GET_EVENT);
				syscall(TASK_EXIT);
				break;
		}
	}
}

void main()
{
	vt *pvt;
	file_header *pf;
	char *sbase,*pdata;

	int modo,ix,k,ok,ox,oy,nf;

	pvt=(vt *)syscall(OPEN_VT,2);
	syscall(VT_TO_FG);
        syscall(CURSOR_OFF);
        syscall(CLS);

        panta=(char *)syscall(VT_GET_SCREEN_BASE);
        ox=oy=0;

        printf("Select a graph");

	if((ix=syscall(FILE_SEL_INT,GRAPHIC,WINDOW_ZIP,0))==-1) syscall(TASK_EXIT);
	nf=syscall(FILE_GET_NFILES,GRAPHIC,WINDOW_ZIP);
	pf=(file_header *)syscall(FILE_SEL_IX,GRAPHIC,WINDOW_ZIP,ix);
	for(;;) {
                syscall(CLS); syscall(CURSOR_OFF);
		showimage ((char *)((int)pf+sizeof(file_header)),ox,oy);
                k=mi_getch();
                switch(k) {
                case K_U: if (oy>0) oy--; break;
                case K_D: oy++; break;
                case K_L: if (ox>0) ox--; break;
                case K_R: ox++; break;
                case ' ': if(ix<nf-1) ix++;
                          pf=(file_header *)syscall(FILE_SEL_IX,GRAPHIC,WINDOW_ZIP,ix);
                          ox=oy=0; break;
                case '\n': if(ix) ix--;
                           pf=(file_header *)syscall(FILE_SEL_IX,GRAPHIC,WINDOW_ZIP,ix);
                           ox=oy=0; break;
                }
	}
}

