#include "init.h"
#include <math.h>
#include <string.h>
#include <ctype.h>

#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "ulib.h"



int atohex(char *pa,unsigned int *result)
{
	char a;
	*result=0;

	for(;;) {
		a=*pa++;
		if (a==' ' || a=='\n' || a==0) break;
		
		if (a>='0' && a<='9') a-='0';
		else if (a>='A' && a<='F') a=a-'A'+10;
		  else if (a>='a' && a<='f') a=a-'a'+10;
		    else return -1;
		
		*result<<=4; *result|=a;
	}
	return 0;
}

int atobin(char *pa,unsigned int *result)
{
	char a;

	*result=0;
	for(;;) {
		a=*pa++;
		if (a==' ' || a=='\n' || a==0) break;
		if (a!='0' && a!='1') return -1;
		a-='0';
		*result<<=1; *result|=a;
	}
	return 0;
}

char getch_vt()
{
	for (;;){
		switch(syscall(VT_GET_EVENT)) {
			case EV_KEYBOARD:
				return syscall(VT_GET_EVENT);
				break;
			case EV_LCD_TAP_PRESS:
				//syscall(TASK_EXIT);
				syscall(VT_GET_EVENT);
				syscall(VT_GET_EVENT);
				break;
		}
	}
}

void getsn_vt(char *buf,int maxn)
{
	char a,*p;
	p=buf;
	for(;;){
		a=getch_vt(); putchar(a);
		if (a==8) { if (p!=buf) p--; continue; }
		if (a=='\n') { *p=0; return;}
		*p++=a;
		if (p==&buf[maxn]) p--;
	}
}

char *comando[33];

void init_comando()
{
comando[0]=	"+";
comando[1]=	"-";
comando[2]=	"*";
comando[3]=	"x";
comando[4]=	"/";
comando[5]=	"^";
comando[6]=	"n";
comando[7]=	"sqr";
comando[8]=	"ln";
comando[9]=	"log";
comando[10]=	"sin";
comando[11]=	"cos";
comando[12]=	"tan";
comando[13]=	"exp";
comando[14]=	"asin";
comando[15]=	"acos";
comando[16]=	"atan";
comando[17]=	"atan2";
comando[18]=	"inv";
comando[19]=	"sw";
comando[20]=	"d";
comando[21]=	"c";
comando[22]=	"deg";
comando[23]=	"rad";
comando[24]=	"hex";
comando[25]=	"bin";
comando[26]=	"dec";
comando[27]=	"pi";
comando[28]=	"e";
comando[29]=	"q";
comando[30]=	"f";
comando[31]=	"help";
comando[32]=	"";
};


#define TORAD (M_PI/180.)
#define MAXNIV 8
#define NMEM 7
void calculadora()
{
	vt *pvt;
	int i,op,st=0,fdeg=0,base=0;
	unsigned int ti;
	double v,pila[MAXNIV],mem[NMEM];
	double torad=TORAD;
	char buf[21];

	init_comando();
	pvt=(vt *)syscall(OPEN_VT,0);
	if (!pvt) syscall(TASK_EXIT);
	syscall(CLS);
	syscall(VT_TO_FG);
	
	for(i=0;i<10;i++) mem[i]=0;
	for(;;) {
		syscall(CLS);
		syscall(HLINE,0,159,11,1);
		syscall(GOTOXY,17,0); printf((fdeg)?"RAD":"DEG");
		if (base) {
			syscall(GOTOXY,13,0);
			if (base==1) printf("HEX");
			else printf("BIN");
		}
		for (i=0;i<MAXNIV;i++) {
			syscall(GOTOXY,0,9-i);
			printf("%d: ",i);
			if (i<st) {
			   if (base) {
				op=pila[i];
				if (base==1) printf("%x",op);
				else printf("%b",op);
			   }else printf("%f",pila[i]);
			}
		}
		syscall(HLINE,0,159,83,1);		
		for (i=0;i<NMEM;i++) {
			syscall(GOTOXY,0,17-i);
			printf("M%1d:",i);
			if (base) {
				op=mem[i];
				if (base==1) printf("%x",op);
				else printf("%b",op);
			}else printf("%f",mem[i]);
		}

		syscall(HLINE,0,159,159-12,1);
		syscall(GOTOXY,0,19);

		getsn_vt(buf,21);

		if (buf[0]=='>') { // a Memoria
			i=buf[1]-'0'; if (i<0 || i>NMEM-1) continue;
			mem[i]=pila[st-1]; continue;
		}
		if (buf[0]=='<') { // de Memoria a pila
			i=buf[1]-'0'; if (i<0 || i>NMEM-1) continue;
			if (st<MAXNIV) pila[st++]=mem[i];
			continue;
		}

		op=-1;
		for (i=0;;i++) {
			if (*comando[i]==0) break;
			if (strcmp(comando[i],buf)==0) {op=i; break;}
		}
		if (op==-1) {
			if (!base) v=atof(buf);
			else if (base==1) { 
			   if (atohex(buf,&ti)) continue;
			   v=ti;
			} else if (base==2) {
			   if (atobin(buf,&ti)) continue;
			   v=ti;
			}
			if (st<MAXNIV) pila[st++]=v;
		} else {
		  switch(op) {
		  case 0: if (st>1) {st--; pila[st-1]+=pila[st];}
		  	  break;
		  case 1: if (st>1) {st--; pila[st-1]-=pila[st];}
		  	  break;
		  case 2:
		  case 3: if (st>1) {st--; pila[st-1]*=pila[st];}
		  	  break;
		  case 4: if (st>1 && pila[st-1]!=0) {
		  		st--; pila[st-1]/=pila[st];
		  	  }
		  	  break;
		  case 5: if (st>1) {st--; pila[st-1]=pow(pila[st-1],pila[st]);}
		  	  break;
		  case 6: pila[st-1]=-pila[st-1]; break;
		  case 7: if (pila[st-1]>=0) pila[st-1]=sqrt(pila[st-1]);
			  break;
		  case 8: if (pila[st-1]>0) pila[st-1]=log(pila[st-1]);
			  break;
		  case 9: if (pila[st-1]>0) pila[st-1]=log10(pila[st-1]);
			  break;
		  case 10: pila[st-1]=sin(torad*pila[st-1]);
			   break;
		  case 11: pila[st-1]=cos(torad*pila[st-1]);
			   break;
		  case 12: pila[st-1]=tan(torad*pila[st-1]);
			   break;
		  case 13: pila[st-1]=exp(pila[st-1]);
			   break;
		  case 14: if (pila[st-1]>=-1 && pila[st-1]<=1)
		  		pila[st-1]=asin(pila[st-1])/torad;
		  	   break;
		  case 15: if (pila[st-1]>=-1 && pila[st-1]<=1)
				pila[st-1]=acos(pila[st-1])/torad;
			   break;
		  case 16: pila[st-1]=atan(pila[st-1])/torad;
			   break;
		  case 17: if (st>1) {st--; pila[st-1]=atan2(pila[st-1],pila[st])/torad;}
			   break;
		  case 18: pila[st-1]=1./pila[st-1];
			   break;
		  case 19: if (st>1) { v=pila[st-2]; pila[st-2]=pila[st-1]; pila[st-1]=v;}
			   break;
		  case 20: if (st<18) {pila[st]=pila[st-1]; st++;}
			   break;
		  case 21: if (st>0) st--; break;
		  case 22: torad=TORAD; fdeg=0; break;
		  case 23: torad=1.0; fdeg=1; break;
		  case 24: base=1; break;
		  case 25: base=2; break;
		  case 26: base=0; break;
		  case 27: if (st<MAXNIV) pila[st++]=M_PI; break;
		  case 28: if (st<MAXNIV) pila[st++]=M_E; break;
		  case 29: syscall(TASK_EXIT);
		  case 30: st=0; break;
		  case 31: //help
		  	   syscall(CLS);
			   for (i=0;;i++) {
				if (*comando[i]==0) break;
				syscall(GOTOXY,(i/20)*6,i%20);
				printf((char *)comando[i]);
			  }
			  getch_vt(pvt);
			  break;
		  }
		}
	}
}

#define NSTACK 0x2000

main()
{
    register char *p;
    
    //necesitamos una pila ms grande por la rutina recursiva
    //if (!(p=(char *)syscall(KMALLOC,NSTACK))) syscall(TASK_EXIT);
    //asm volatile("movea.l %0,%%sp"::"a"(&p[NSTACK]));

    calculadora();
}
