#include "init.h"
#include "../common.h"
#include "../event.h"
#include "../syscall.h"
#include "ulib.h"
#include "fix_fft.h"

extern inline unsigned char *getp()
{
char *pa;
asm volatile("trap #2\n	move.l %%d0,%0":"=a"(pa));
return pa;
}

#include "fix_fft.c"

void main()
{
	vt *pvt;
	int i;
	unsigned char *abuf;
	short *sr,*si,*sp,modo,o;

	modo=0;
	pvt=(vt *)syscall(OPEN_VT,0);
	if (!pvt) syscall(TASK_EXIT);
	syscall(VT_TO_FG);
	
	abuf=(unsigned char *)syscall(KMALLOC,1024);
	if(!abuf) syscall(TASK_EXIT);

	sr=(short *)syscall(KMALLOC,512);
	if(!sr) syscall(TASK_EXIT);
	si=(short *)syscall(KMALLOC,512);
	if(!si) syscall(TASK_EXIT);
	sp=(short *)syscall(KMALLOC,256);
	if(!sp) syscall(TASK_EXIT);

	syscall(CLS);
	syscall(GOTOXY,0,18); printf("t f s r");
	syscall(CURSOR_OFF);
	syscall(RECTANGLE,0,0,128,128,1);

	for (i=0;i<128;i++) sp[i]=0;

	for(;;) {
		if (syscall(AUDIO_START,(int)abuf,1024)) {
			syscall(GOTOXY,0,18);
			printf("Error AUDIO_START");
			syscall(TASK_SLEEP,0);
		}
		while(getp()<&abuf[264]) syscall(TASK_SLEEP,2);
		syscall(AUDIO_STOP);
		
		if (modo&1) {
		    for (i=0;i<256;i++) {
			sr[i]=(abuf[i+8]-128)<<8;
			si[i]=0;
		    }
		    window(sr,256);
		    i=fix_fft(sr,si,8,0);
		    fix_loud(sr,sr,si,128,i);

		    o=sp[0]; sp[0]=(sr[0]+sp[0])>>1;
		    for (i=1;i<128;i++) {
			syscall(LINE,i,1-o,i+1,1-sp[i],0);
			o=sp[i];
			sp[i]=(sr[i]+sp[i])>>1;
			syscall(LINE,i,1-sp[i-1],i+1,1-sp[i],1);
		    }
		} else {
		    o=sp[0]; sp[0]=-(abuf[8]>>1);
		    for (i=1;i<128;i++) {
			syscall(LINE,i,1-o,i+1,1-sp[i],0);
			o=sp[i];
			sp[i]=-(abuf[i+8]>>1);
			syscall(LINE,i,1-sp[i-1],i+1,1-sp[i],1);
		    }
		}

		i=syscall(VT_GET_EVENT_NB);
		switch(i) {
		case EV_LCD_TAP_PRESS:
			syscall(TASK_EXIT);
		case EV_KEYBOARD:
			i=syscall(VT_GET_EVENT);
			switch(i) {
			case 't': modo&=~1; break;
			case 'f': modo|=1; break;
			case 's': modo|=2; break;
			case 'r': modo&=~2; break;
			}
			break;
		}
		if(modo&2) syscall(TASK_SLEEP,32);
	}
}
