#include "common.h"
#include "vt.h"
#include "lcd.h"
#include "event.h"
#include "task.h"
#include "fifo.h"
#include "lang.h"

extern fifo ffevent;
extern vt vt_table[];
extern int ev_pid;

short int offset_x=91,offset_y=155,gain_x=48,gain_y=72;

void pen_calibrate()
{
	char *p,i,fa=1,fb=1,pd=0;
	unsigned short ev,rx,ry,rax,ray,rbx,rby;
	
	cls();
	
	line(140,10,160,10,1);
	line(150,0,150,20,1);
	line(0,150,20,150,1);
	line(10,140,10,160,1);

	gotoxy(5,8); kprintf(MSG_PEN_CAL1);
	gotoxy(4,9); kprintf(MSG_PEN_CAL2);
	gotoxy(7,10); kprintf(MSG_PEN_CAL3);
	cursor_off((vt *)0);

	offset_x=offset_y=gain_x=gain_y=0;

	do{
		task_sleep(1);
		ev=fifo_getnb(&ffevent);
		if (ev==EV_TAP_PRESS) pd=1;
		if (ev==EV_TAP_REL) {
			pd=0;
			if (rx<512) {fa=0; rax=rx; ray=ry; circle(10,150,6,1); }
			else {fb=0; rbx=rx; rby=ry; circle(150,10,6,1); }
		}
		if (pd) get_touch_xy(&rx,&ry);
	}while (fa || fb);
	
	offset_x=(150*rax-10*rbx)/140;
	gain_x=38400/(rbx-offset_x);
	
	offset_y=(150*rby-10*ray)/140;
	gain_y=38400/(ray-offset_y);
	
	cls();
	kprintf("OFFS_X=%d\n",offset_x);
	kprintf("OFFS_Y=%d\n",offset_y);
	kprintf("GAIN_X=%d\n",gain_x);
	kprintf("GAIN_Y=%d\n",gain_y);
	
	cursor_on((vt *)0);
}

int get_pen_xy(short *x, short *y)
{
	get_touch_xy(x,y);
	if (*x<40 || *x>984) return -1;
	if (*y<40 || *y>980) return -1;
	
	*x=((*x-offset_x)*gain_x)>>8;
	*y=((*y-offset_y)*gain_y)>>8;
	
	return 0;
}
