#include "common.h"
#include "lcd.h"

extern void _data;

extern unsigned char font[];

unsigned char panic_x=0,panic_y=0;

void panic_wrchar(int x, int y, unsigned char a)
{
	short i;
	unsigned char *pp,*pf;

	if (x<0 || x>19) return;
	if (y<0 || y>19) return;

	pf=(unsigned char *)font;
	pf+=((unsigned int)a)<<3;

	pp=(unsigned char *) *(volatile unsigned long *)0xfffffa00;
	pp+=(y*160+x);
	for (i=8;i;i--) {
	        *pp=*pf++;
	        pp+=20;
	}
}

void panic_putch(char a)
{
	int *ps,*pd,i;

        if (panic_y>19) return;

        switch(a) {
	case '\n':	panic_x=0;
			panic_y++;
			break;
	case '\r':	panic_x=0;
			break;
	case '\t':	panic_x+=4;
			panic_x&=~3;
			break;
	case 127:
	case 8:		if (panic_x>0) panic_x--;
			panic_wrchar(panic_x,panic_y,' ');
			break;
	default:	panic_wrchar(panic_x,panic_y,a);
			panic_x++;
			break;
	}
	if (panic_x>19) {
		panic_x=0;
		panic_y++;
	}
}

void panic_puts(char *p)
{
        while (*p) panic_putch(*p++);
}

void panic_prhex(int d,int nd)
{
    int i,j;
    char buf[10];

    buf[9]=0;
    for (i=0;i<nd;i++) {
        j=d&0xf;
        buf[8-i]=(j>9)?j+'A'-10:j+'0';
        d>>=4;
    }
    i--;
    panic_puts(&buf[8-i]);
}

void panic(char *msg)
{
        unsigned char *p=(unsigned char *)((int)&_data-3200);
        int i;

        // Todas las interrupciones deshabilitadas
        asm volatile("move.w #0x2700,%sr");

        // Inicializamos modo de video provisional
        set_video_mode(0);              // 1bpp
        *(volatile unsigned long *)0xfffffa00=(int)p; // Base
        for (i=0;i<3200;i++) *p++=0x0;    // cls
        panic_x=panic_y=0;              // cursor

        if (msg) {
                panic_puts(msg);
                // Paramos el reloj de la CPU y no retornamos
                for(;;) {asm volatile (" move.b  #0x80,0xfffff207");}
        }
        // En otro caso retornamos con la pantalla lista para imprimir
        // y las interrupciones apagadas
}