/****************** Gestin de las MEMORIAS ******************

Memorias:	RAM usuario:	U_RAM
		RAM supervisor:	S_RAM
		Flash:		FLASH
		
**************************************************************/
#include "common.h"
#include "mem.h"
#include "task.h"
#include "lock.h"

unsigned char u_ram_map[U_RAM_SZ/PAGE];
unsigned char s_ram_map[S_RAM_SZ/PAGE];

// Variables del linker-script:
extern void _buser;
extern void _data;
extern void _end;

#include "lowio.h"

void init_mem()
{
	short int i,j;
	unsigned int *pin;
	
	//Reservamos las pginas ocupadas por el kernel
	for(i=0;i<((int)&_end-(int)&_data)>>L2PAGE;i++) s_ram_map[i]=0xff;
	
	//Liberamos el resto de la RAM del supervisor....
	for(;i<((S_RAM_SZ-512)>>L2PAGE);i++) s_ram_map[i]=0;
	
	//...salvo un poco de RAM para la pila de la tarea 0
	for(;i<(S_RAM_SZ>>L2PAGE);i++) s_ram_map[i]=0xff;
	

#ifndef DV2MB
	//Reservamos las pginas ocupadas por la tabla de vectores
	for (i=0;i<(0x400)>>L2PAGE;i++) u_ram_map[i]=0xff;
#endif	
	//Reservamos las reas de datos de las aplicaciones
	pin=(unsigned int *)APPLOC;
	i=(pin[1]-(int)&_buser)>>L2PAGE;
	j=(pin[2]-(int)&_buser+PAGE-1)>>L2PAGE;
	if (pin[1]!=0xffffffff) for (;i<j;i++) u_ram_map[i]=0xff;
	
	//Liberamos el resto de la RAM del usuario
	for(;i<((U_RAM_SZ-512)>>L2PAGE);i++) u_ram_map[i]=0;
	
}

/*************************************************************************
kmalloc:	Reserva de memoria
Esta funcin debe ser ejecutada por una sla tarea, y es demasiado lenta
para apagar las interrupciones, as que usaremos un semforo con TAS para
bloquear las tareas pendientes hasta que les toque su vez.
*************************************************************************/

extern TSS task_table[];
extern TSS *cur_task;

char *tmalloc(short type,unsigned char tix, unsigned int nbytes)
{
	unsigned int i,s,st,l,nb,n;
	unsigned char *bmap,*base,f;
	static char busy=0;	//Semforo
	
	lock(&busy);

	switch(type) {
	case U_RAM:	bmap=u_ram_map; base=&_buser; nb=U_RAM_SZ/PAGE; break;
	case S_RAM:	bmap=s_ram_map; base=&_data; nb=S_RAM_SZ/PAGE; break;
	case FLASH:
	default:	unlock(&busy); return (char *)0;
	}
	
	/** Buscamos el hueco ms pequeo en el que cabe el bloque pedido **/

	n=(nbytes+PAGE-1)>>L2PAGE;
	s=f=0; l=st=0xffffffff;
	for (i=0;i<nb;i++) {
		if (bmap[i] || i==nb-1) {
			if (f) {
				f=0;
				if(i-s>=n && i-s<l) {
					l=i-s;
					st=s;
				}
			}
		} else {
			if (!f) s=i;
			f=1;
		}
	}
	if (st!=0xffffffff) {
		/** Marcamos como ocupadas las pginas encontradas **/
		for (i=st;i<st+n;i++) bmap[i]=tix;
		/** Calculamos la direccin de comienzo del bloque **/
		base+=(st<<L2PAGE);
	} else base=(char *)0;
		
	unlock(&busy);	/** Desbloqueamos otras tareas **/

	return base;
}

char *kmalloc(short type,unsigned int nbytes)
{
	int tix;
	tix=((unsigned int)cur_task - (unsigned int)task_table)/sizeof(TSS);
	return tmalloc(type,tix,nbytes);
}

/*-------------------------------------------------------------------------*/

int check_mem_range(unsigned char *buf, unsigned int nbytes)
{
	int tix,i,s,n,nb;

	tix=((unsigned int)cur_task - (unsigned int)task_table)/sizeof(TSS);
	s=(unsigned int)buf;
        if (s<(int)&_data) {
            if (s<(int)&_buser) return -1;
            s-=(unsigned int)&_buser; s>>=L2PAGE;
	    n=(nbytes+PAGE-1)>>L2PAGE;
	    nb=U_RAM_SZ/PAGE;
	    n+=s; if (n>nb) return -1;
	    for (i=s;i<n;i++) if (u_ram_map[i]!=tix) return -1;
        } else {
            s-=(unsigned int)&_data; s>>=L2PAGE;
	    n=(nbytes+PAGE-1)>>L2PAGE;
	    nb=S_RAM_SZ/PAGE;
	    n+=s; if (n>nb) return -1;
	    for (i=s;i<n;i++) if (s_ram_map[i]!=tix) return -1;
        }
	return 0;
}

int check_mem_ro(unsigned char *buf, unsigned int nbytes)
{
	unsigned int dir;

	dir=(unsigned int)buf;

	if (dir>=0x10c00000 && (dir+nbytes)<0x10d00000) return 0;

#ifdef DV2MB
	if (dir>=0 && (dir+nbytes)<0x100000) return 0;
	if (dir>0x10000000 && (dir+nbytes)<0x10040000) return 0;
#else
	if (dir>=0 && (dir+nbytes)<0x40000) return 0;
#endif
	return -1;
}

/********************************************************************
kfree:		Libera memoria
********************************************************************/

int kfree(char *buffer,int nbytes)
{
	unsigned int i,s,n,nb;
	char *bmap;

	n=(nbytes+PAGE-1)>>L2PAGE;
	if (buffer >= (char*)&_buser && buffer <(char*)(&_buser+U_RAM_SZ)){
		bmap=u_ram_map;
		s=(unsigned int)buffer; s-=(unsigned int)&_buser; s>>=L2PAGE;
		nb=U_RAM_SZ/PAGE;
	} else if (buffer>=(char*)&_data && buffer<(char*)&_data+S_RAM_SZ){
		bmap=s_ram_map;
		s=(unsigned int)buffer; s-=(unsigned int)&_data; s>>=L2PAGE;
		nb=S_RAM_SZ/PAGE;
	} else return -1;
	n+=s; if (n>nb) n=nb;
	for (i=s;i<n;i++) bmap[i]=0;
#ifdef DEBUG	
	dump_bmaps();
#endif
	return 0;
}

void free_task_mem(int itask)
{
	int i;
	for (i=0;i<U_RAM_SZ/PAGE;i++) if (u_ram_map[i]==itask) u_ram_map[i]=0;
	for (i=0;i<S_RAM_SZ/PAGE;i++) if (s_ram_map[i]==itask) s_ram_map[i]=0;
#ifdef DEBUG
	dump_bmaps();
#endif
}
