#include "lock.h"

/*-------------------- Basic PORT INIT ----------------------*/

void init_lowio()
{
	unsigned char *p=(unsigned char *)0xfffff408;

	/* Init Ports */
	*p++=0x40; *p++=0x7f; *p++=0x00; *p++=0x40; p+=4;
	*p++=0xff; *p++=0x00; *p++=0x00; *p++=0x00; p+=4;
	*p++=0x0b; *p++=0xff; *p++=0xf4; *p++=0x20; *p++=0x00; *p++=0x00; *p++=0x00; *p++=0x00;
	*p++=0x05; *p++=0xff; *p++=0xfa; *p++=0x00; p+=4;
	*p++=0x05; *p++=0xfe; *p++=0x02; *p++=0x05; p+=4;
	*p++=0x00; *p++=0x3d; *p++=0x3c; *p++=0x3d;
	
	*((volatile unsigned char  *)0xfffff423)=0; //PE pins to SPI,UART
	*((volatile unsigned short *)0xfffff802)=0xe209; // SPI conf
}

/*****------------------ SPI ------------------*****/

char spi_busy=0;	// Semaforo

void delay(int i)
{
	volatile int j=i;
	
	for (;j;j--);
}

void lp_delay(int i)
{
	for (;i>0;i-=32) *((volatile char *)0xfffff207)=0x81; //doze mode
	*((volatile char *)0xfffff207)=0x1f; //doze mode off
}

unsigned short spi(unsigned short dato)
{
	unsigned short i;

	asm volatile("
	move.l	#0xfffff000,%%a0
	bclr	#0,0x419(%%a0)		|PD0=0
	pea	50.w
	jsr	delay
	addq.l	#4,%%sp
	bset	#1,0x802(%%a0)		|Enable SPIM
	move.w	%1,0x800(%%a0)		|SPI_out
	bset	#0,0x802(%%a0)		|Trigger xchg

1:	btst	#7,0x803(%%a0)
	beq	1b
	bclr	#7,0x803(%%a0)		|Clear IRQ
	move.w	0x800(%%a0),%0		|SPI_in
	bclr	#1,0x802(%%a0)		|Disable SPIM
	bset	#0,0x419(%%a0)		|PD0=1
	":"=d"(i):"m"(dato));

	delay(50);
	return i;
}

char get_touch_xy(short *x, short *y)
{
	// Uso SPI atmico
	lock(&spi_busy);

	asm volatile ("bset.b #4,0xfffff305");
	spi(0);
	*x=spi(0x40);
	*y=spi(0);
	asm volatile ("bclr.b #4,0xfffff305");	
	unlock(&spi_busy);
	/* Si el valor es de borde lo descartamos */
	if (*x<10 || 
			*x>1014 || 
			*y<10 || 
			*y>1014) {
		return 0;
	} else {
		return 1;
	}
}

int get_batt()
{
	int v;
	// Uso SPI Atmico
	lock(&spi_busy);

	spi(0x80);
	v=spi(0x80);
	v*=3417; v>>=10;

	unlock(&spi_busy);
	return v;
}

void pll_off()
{
	//Uso SPI atmico
	lock(&spi_busy);

	spi(0x100);

	asm("
	movea.l	#0xfffff000,%a0

	move.l  0x304(%a0),%d0
	move.l	%d0,-(%sp)
	move.l	#0x00fbffef,0x304(%a0)	|Solo IRQ3 y RTC

	bclr.b	#0,0xb11(%a0)		|deshabilita stopwatch IRQ

	bset.b	#0,0x429(%a0)		|PF0=1
	bclr.b	#2,0x429(%a0)		|PF2=0
	bset.b	#6,0x409(%a0)		|PB6=1

	move.b	#0xff,0x423(%a0)	|PE gpio
	move.b	#0xff,durmiendo

	move.w	#0x2410,0x200(%a0)
1:	btst.b	#7,0x202(%a0)
	bne	1b
2:	btst.b	#7,0x202(%a0)
	beq	2b
	move.w	#0x2418,0x200(%a0)	|PLL OFF

	stop	#0x2000

	move.b	#0x00,0x423(%a0)	|PE serie

	bclr.b	#1,0x419(%a0)		|PD1=0 reset Nexus
	pea.l	1000
	jsr	delay
	lea.l	4(%sp),%sp
	bset.b	#1,0x419(%a0)		|PD1=1

	bclr.b	#0,0x429(%a0)		|PF0=0
	bset.b	#2,0x429(%a0)		|PF2=1
	clr.b	durmiendo
	pea.l	10000
	jsr	delay
	lea.l   4(%sp),%sp
	pea.l	0
	jsr	spi			|Despierta Nexus
	lea.l   4(%sp),%sp
	move.l	(%sp)+,%d0
	move.l	%d0,0xfffff304		|Habilita interrupciones
	");

	unlock(&spi_busy);
}



/*-------------------------------- SONIDO ----------------------------------*/

char pwm_busy=0;

void sound(int frec,int vol)
{
	int d;
	
	if (frec<=0) return;
	if (vol<0 || vol>15) return;
	d=259072/frec;
	d--; if (d<0 || d>126) return;
	
	lock(&pwm_busy);
	*(unsigned char *)0xfffff501=0x10;
	*(unsigned char *)0xfffff500=d;
	*(unsigned char *)0xfffff504=30;	//Contador 5 bits
	*(unsigned char *)0xfffff503=vol;
	unlock(&pwm_busy);
}

void sound_vol(int vol)
{
	if (vol<0 || vol>15) return;
	lock(&pwm_busy);
	*(unsigned char *)0xfffff503=vol;
	unlock(&pwm_busy);
}

void sound_off()
{
	lock(&pwm_busy);
	*(unsigned char *)0xfffff501=0x00;
	unlock(&pwm_busy);
}

