#include <stdlib.h>
#include <stdio.h>

int X,Y;
unsigned char panta[160*160];

readpgm(char *fn){
	int i,j,k,ix,iy,mgr;
	FILE *fp;
	unsigned char buf[256],*p;
	unsigned char *ppgm;
	float scale,x,y,ox,oy,dx,dy,g0,g1,g2,g3;
	
	if ((fp=fopen(fn,"r"))==NULL) {perror("fopen"); exit(1);}

	printf("%s\n",fn);

	fgets(buf,256,fp);
	
	if (strcmp(buf,"P5\n")!=0) {
		fprintf(stderr,"No es fichero PGM/P5\n");
		//exit(0);
	}
	do {
		fgets(buf,256,fp);
	} while (buf[0]=='#');
	sscanf(buf,"%d%d",&X,&Y);
	//fprintf(stderr,"X=%d Y=%d\n",X,Y);
	fgets(buf,256,fp);
        if (atoi(buf)>255) {  
	        fprintf(stderr,"N de colores no soportado\n");
	        exit(0);
        }
	if ((ppgm=malloc(X*Y))==NULL) {perror("malloc"); exit(1);}
	fread(ppgm,1,X*Y,fp);
	fclose(fp);

	/* buscamos nivel de gris medio */
	
	//printf("Buscando gris medio... "); fflush(stdout);
	p=ppgm;
	mgr=0;
	for (i=0;i<Y;i++) {
		k=0;
		for (j=0;j<X;j++) {
			k+=*p++;
		}
		k/=X;
		mgr+=k;
	}
	mgr/=Y;
	//printf("%d\n",mgr);

	/* Interpolacin a matriz de 160x160 */
	
	if (X>Y) scale=X/160.; else scale=Y/160.;
	if (X>Y) { ox=0; oy=(X-Y)/2.; } else {ox=(Y-X)/2.; oy=0;}
	
	//printf("Scale=%f ox=%f oy=%f\n",scale,ox,oy);
	//printf("interpolando\n"); 
	
	for(i=0;i<160;i++) {
	    y=i*scale-oy; iy=(int)y;
	    for(j=0;j<160;j++) {
	    	x=j*scale-ox; ix=(int)x;
	    	if (x<0 || x>X || y<0 || y>Y) {
	    		panta[i*160+j]=mgr;
	    		continue;
	    	}
	    	k=ix+iy*X;
	    	dx=x-((int)x); dy=y-((int)y);
	    	g0=ppgm[k];
	    	if (ix==X-1) g1=g0; else g1=ppgm[k+1];
	    	if (iy==Y-1) g2=g0; else g2=ppgm[k+X];
	    	if (iy==Y-1 || ix==X-1) g3=g2; else g3=ppgm[k+X+1];
	    	g0+=(g1-g0)*dx; g2+=(g3-g2)*dx;
	    	g0+=(g2-g0)*dy;
	    	panta[i*160+j]=(int)(g0+0.5);
	    }
	}
	
	free(ppgm);
	
	if ((fp=fopen(fn,"w"))==NULL) {perror("fopen"); exit(1);}
	fprintf(fp,"P5\n");
	fprintf(fp,"#CREATOR me\n");
	fprintf(fp,"#version 1.0\n");
	fprintf(fp,"160 160\n");
	fprintf(fp,"255\n");
	
	fwrite(panta,1,160*160,fp);
	fclose(fp);
}

main(int argc, char **argv)
{
	int i;

	if (argc<2) {
		printf("Uso: %s <ficheros.pgm>\n",argv[0]);
		exit(0);
	}

	for (i=1;i<argc;i++) {
		readpgm(argv[i]);
	}
}
