#include <stdlib.h>
#include <stdio.h>

int X,Y;
unsigned char video[160*160];

readpgm(char *fn){
	int i,j,k,ix,iy,mgr;
	FILE *fp;
	unsigned char buf[256],*p;
	unsigned char *ppgm;
	float scale,x,y,ox,oy,dx,dy,g0,g1,g2,g3;
	
	if ((fp=fopen(fn,"r"))==NULL) {perror("fopen"); exit(1);}

	printf("%s\n",fn);

	fgets(buf,256,fp);
	
	if (strcmp(buf,"P5\n")!=0) {
		fprintf(stderr,"No es fichero PGM/P5\n");
		//exit(0);
	}
	do {
		fgets(buf,256,fp);
	} while (buf[0]=='#');
	sscanf(buf,"%d%d",&X,&Y);
	//fprintf(stderr,"X=%d Y=%d\n",X,Y);
	fgets(buf,256,fp);
        if (atoi(buf)>255) {  
	        fprintf(stderr,"N de colores no soportado\n");
	        exit(0);
        }
	if ((ppgm=malloc(X*Y))==NULL) {perror("malloc"); exit(1);}
	fread(ppgm,1,X*Y,fp);
	fclose(fp);

	if(X==160 && Y==160) {
		memcpy(video,ppgm,160*160);
		free(ppgm);
		return;
	}

	/* buscamos nivel de gris medio */
	
	//printf("Buscando gris medio... "); fflush(stdout);
	p=ppgm;
	mgr=0;
	for (i=0;i<Y;i++) {
		k=0;
		for (j=0;j<X;j++) {
			k+=*p++;
		}
		k/=X;
		mgr+=k;
	}
	mgr/=Y;
	//printf("%d\n",mgr);

	/* Interpolacin a matriz de 160x160 */
	
	if (X>Y) scale=X/160.; else scale=Y/160.;
	if (X>Y) { ox=0; oy=(X-Y)/2.; } else {ox=(Y-X)/2.; oy=0;}
	
	//printf("Scale=%f ox=%f oy=%f\n",scale,ox,oy);
	//printf("interpolando\n"); 
	
	for(i=0;i<160;i++) {
	    y=i*scale-oy; iy=(int)y;
	    for(j=0;j<160;j++) {
	    	x=j*scale-ox; ix=(int)x;
	    	if (x<0 || x>X || y<0 || y>Y) {
	    		video[i*160+j]=mgr;
	    		continue;
	    	}
	    	k=ix+iy*X;
	    	dx=x-((int)x); dy=y-((int)y);
	    	g0=ppgm[k];
	    	if (ix==X-1) g1=g0; else g1=ppgm[k+1];
	    	if (iy==Y-1) g2=g0; else g2=ppgm[k+X];
	    	if (iy==Y-1 || ix==X-1) g3=g2; else g3=ppgm[k+X+1];
	    	g0+=(g1-g0)*dx; g2+=(g3-g2)*dx;
	    	g0+=(g2-g0)*dy;
	    	video[i*160+j]=(int)(g0+0.5);
	    }
	}
	
	free(ppgm);
	
	/****************
	if ((fp=fopen(fn,"w"))==NULL) {perror("fopen"); exit(1);}
	fprintf(fp,"P5\n");
	fprintf(fp,"#CREATOR me\n");
	fprintf(fp,"#version 1.0\n");
	fprintf(fp,"160 160\n");
	fprintf(fp,"255\n");
	
	fwrite(video,1,160*160,fp);
	fclose(fp);
	*****************/
}

main(int argc, char **argv)
{
	unsigned char panta[12800];
	unsigned char fname[256],ext[8],*p;
	int i,j,k,n,fd,bpp;
	unsigned char a,b,c,d,da,db,dc,dd;

	if (argc<3) {
		printf("Uso: %s bpp <ficheros.pgm>\n",argv[0]);
		exit(0);
	}
	bpp=atoi(argv[1]);
	for (j=2;j<argc;j++) {
		readpgm(argv[j]);

		switch(bpp) {
		case 1:	for (i=0;i<3200;i++) {
			    for(k=0;k<8;k++) {
			    	panta[i]<<=1;
			    	if ((rand()&0xff)<video[(i<<3)+k]) panta[i]++;
			    }
			    panta[i]^=0xff;
			} 
			break;
		case 2:	for(i=0;i<25600;i+=4) { 
				a=video[i]; b=video[i+1];
				c=video[i+2]; d=video[i+3];
				da=a&0xf; db=b&0xf; dc=c&0xf; dd=d&0xf;
				a>>=6; b>>=6; c>>=6; d>>=6;
				if ((rand()&0x3)<da) if (a<3) a++;
				if ((rand()&0x3)<db) if (b<3) b++;
				if ((rand()&0x3)<dc) if (c<3) c++;
				if ((rand()&0x3)<dd) if (d<3) d++;
				panta[i>>2]=(a<<6)|(b<<4)|(c<<2)|d;
				panta[i>>2]^=0xff;
			}
			break;
		case 4:
			for(i=0;i<25600;i+=2) {
				a=video[i]; b=video[i+1];
				da=a&0xf; db=b&0xf;
				a>>=4; b>>=4;
				if ((rand()&0xf)<da) if (a<15) a++;
				if ((rand()&0xf)<db) if (b<15) b++;
				panta[i>>1]=(a<<4)|b; panta[i>>1]^=0xff;
			}
			break;
		}

		strcpy(fname,argv[j]);
		p=&fname[strlen(fname)-1];
		while (*p!='.' && p>fname) p--;
		if (p==fname) p=&fname[strlen(fname)];
		sprintf(ext,".%1dbpp",bpp);
		strcpy(p,ext);
		//printf("\n%s\n",fname);
		if((fd=creat(fname,0666))==-1) {perror("creat"); exit(1);}
		write(fd,panta,3200*bpp);
		close(fd);
	}
}
