#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define TABLE	"userland/table.s"
#define ROMLIB_DIR "romlib/"
#define AS "/usr/local/gnu/bin/m68k-pic-coff-as"
#define AR "/usr/local/gnu/bin/m68k-pic-coff-ar"

void do_asm(int dir, char *pasm)
{
	char buf[256];
	FILE *fp;
	
	sprintf(buf,"%s%s.s",ROMLIB_DIR,pasm);
	if((fp=fopen(buf,"w"))==NULL) {perror("fopen"); exit(1);};
	fprintf(fp,"\t.globl\t%s\n",pasm);
	fprintf(fp,"%s:\tmovea.l\t0x%x,%%a0\n",pasm,dir);
	fprintf(fp,"\tjmp\t(%%a0)\n");
	fclose(fp);
	sprintf(buf,"%s -o %s%s.o %s%s.s\n",AS,ROMLIB_DIR,pasm,ROMLIB_DIR,pasm);
	system(buf);
}

int main(int argc, char **argv)
{
	int dir=0x10c2000c;
	char buf[256],*p,*pp;
	FILE *fp;
	
	if ((fp=fopen(TABLE,"r"))==NULL) { perror("fopen"); exit(1);}

	do {
		fgets(buf,256,fp);
	} while (!strstr(buf,"ROMLIB"));
	
	for(;;) {
		fgets(buf,256,fp);
		if (feof(fp)) break;
		p=strstr(buf,".long");
		if (!p) continue;
		p=&p[5];
		while(*p==' ' || *p=='\t') p++;
		pp=p;
		while(*pp!='\n' && *pp!='\r' && *pp!=0) pp++;
		*pp=0;
		printf("0x%x	%s\n",dir,p);
		
		do_asm(dir,p);
		dir+=4;
	}

	sprintf(buf,"%s -q lib/librom.a %s*.o",AR,ROMLIB_DIR);
	system(buf);

	fclose(fp);
}
