/************************************************************************
Loader for several Hexadecimal file formats

	- Intel Hex
	- Mostek Hex
	- Motorola S-record Hex
	
*************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define ROMBASE	0x10c00000
#define ROMLEN	0x00100000

unsigned char mem[ROMLEN];

unsigned int hexdata(char *p,int nb)
{
	char buf[16];
	unsigned int i;
	
	buf[0]='0'; buf[1]='X';
	for (i=2;i<(nb*2+2);i++) buf[i]=*(p++);
	buf[i]=0;
	sscanf(buf,"%X",&i);
	return i;
}

void loadhex(char *fn)
{
	unsigned char buf[256],dat[256],*p,*formato;
	int i,j,n,tipo;
	unsigned int dirbase,dir,chk,fdir,f=0;
	FILE *fp;
	
	if((fp=fopen(fn,"r"))==NULL) {
		printf("Error : Cannot open file. File :%s\n",fn);
		exit(0);
	}
	
	for(;;){
		fgets(buf,256,fp);
		if (feof(fp)) break;
		switch (buf[0]) {
		case ':':	/** Formato INTEL **/
			formato="Intel Hex";
			p=buf+1;
			chk=0;
			n=hexdata(p,1); p+=2;	// N de bytes de datos
			chk+=n;
			dirbase=hexdata(p,2); p+=4;
			chk+=dirbase>>8;
			chk+=dirbase&0xff;
			tipo=hexdata(p,1); p+=2;
			chk+=tipo;
			if (tipo) break;
			for (i=0;i<n;i++) {
				dat[i]=hexdata(p,1);
				p+=2;
				chk+=dat[i];
			}
			chk+=hexdata(p,1);
			chk&=0xff;
			//printf("INTEL N=0x%x BASE=0x%x TIPO=%d CHK=%x\n",n,dirbase,tipo,chk);
			break;
			
		case ';':	/** Formato MOSTEK **/
			formato="Mostek Hex";
			p=buf+1;
			chk=0;
			n=hexdata(p,1); p+=2;
			chk+=n;
			if (n==0) break;
			dirbase=hexdata(p,2); p+=4;
			chk+=dirbase>>8;
			chk+=dirbase&0xff;
			for (i=0;i<n;i++) {
				dat[i]=hexdata(p,1);
				p+=2;
				chk+=dat[i];
			}
			chk-=hexdata(p,2);
			//printf("MOS N=0x%x BASE=0x%x CHK=%x\n",n,dirbase,chk);
			break;
			
		case 'S':	/** Formato MOTOROLA **/
			formato="Motorola S-record";
			n=chk=0;
			p=buf+1;
			tipo=*(p++)-'0';
			if (tipo==0) break;
			if (tipo>3) break;
			n=hexdata(p,1); p+=2;
			chk+=n;
			n-=tipo+2;
			dirbase=hexdata(p,tipo+1); p+=(tipo+1)*2;
			for (i=0;i<tipo+1;i++) chk+=(dirbase>>(i*8))&0xff;
			for (i=0;i<n;i++) {
				dat[i]=hexdata(p,1);
				p+=2;
				chk+=dat[i];
			}
			chk+=hexdata(p,2);
			chk++;
			chk&=0xff;
			//printf("MOTOROLA TIPO=%d N=0x%x BASE=0x%x CHK=%x\n",tipo,n,dirbase,chk);
			break;
			
		default:
			printf("Error : Unrecognized File Format. File :%s\n",fn);
			exit(0);
		}
		if (n==0) continue;
		if (chk) {
			printf("Error : Checksum Test Failed. File :%s\n",fn);
			exit(0);
		}
		for(i=0;i<n;i++) {
			j=dirbase+i-ROMBASE;
			if (j>=0 && j<ROMLEN) mem[j]=dat[i];
		}
		if (f==0) fdir=dirbase;
		f=1;
	}
	fclose(fp);
	printf("File Loaded :%s . Format :%s . Base :0x%X\n",fn,formato,fdir);
}

main(int argc,char **argv)
{
	int i,fd;

	if(argc<3) {
		printf("Uso: %s <fich.BIN> <lista ficheros.HEX>\n",argv[0]);
		exit(0);
	}
	
	for (i=0;i<ROMLEN;i++) mem[i]=0xff;
	
	for (i=2;i<argc;i++) loadhex(argv[i]);

	if((fd=creat(argv[1],0666))==-1) {
		perror("creat");
		exit(1);
	}
	
	//for (i=ROMLEN-1;i;i--) if (mem[i]!=0xff) break;
	//i+=0xffff; i&=0xffff0000;	// alineamos a 64Kb
	
	write(fd,mem,ROMLEN);
	close(fd);
}
