/* Ojo: Compilar con:
gcc -o mkfs -fpack-struct mkfs.c
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include "../file.h"

#define IMAGE "feos.rom"
#define BASE 0x10c00000

char *file_type[]={"DEL","BIN","EXE","TXT","GR","3D","SND","MOV","AG","DB",(char *)0};
char *long_file_type[]={"Borrado","Datos Binarios","Cdigo Binario","Texto","Grfico",
			      "Grfico 3D","Sonido","Animacin","Agenda","Base de Datos",
			      (char *)0};

char *bin_code_type[]={"Borrado","C. Mquina PIC","Bytecode(JAVA)",
			     "Tokem BASIC",(char *)0};

char *txt_type[]={"Borrado","ASCII","ASCII compr.","Hipertexto","fuente ASM",
			"Fuente C","Fuente C++","Fuente JAVA","Fuente Basic","Fuente FORTH",
			(char *)0};

char *gr_type[]={ "Borrado","Pantalla 1bpp","Pantalla 2bpp","Pantalla 4bpp","Ventana",
			"Ventana compr.","Vector ASCII","Vector bin.",(char *)0};


typedef struct {
	char *ext;
	unsigned char tipo;
	unsigned char subt;
} file_id;

file_id fidt[]={
	"bin",	BINARY_DATA,	1,
	"pic",	BINARY_CODE,	MC_PIC,
	"txt",	TEXT,		ASCII_RAW,
	"c",	TEXT,		PROGRAM_SOURCE_C,
	"h",	TEXT,		PROGRAM_SOURCE_C,
	"s",	TEXT,		PROGRAM_SOURCE_ASM,
	"asm",	TEXT,		PROGRAM_SOURCE_ASM,
	"1bpp",	GRAPHIC,	SCREEN_DUMP_1BPP,
	"2bpp",	GRAPHIC,	SCREEN_DUMP_2BPP,
	"4bpp",	GRAPHIC,	SCREEN_DUMP_4BPP,
        "dct",  GRAPHIC,        WINDOW_ZIP,
        "ag",	AGENDA,		1,
	NULL,	0,		0
};

unsigned char mem[0x100000];

int toBE(int dato)
{
	union {
		int i32;
		char c[4];
	} a;
	
	a.c[0]=(dato>>24)&0xff;
	a.c[1]=(dato>>16)&0xff; 
	a.c[2]=(dato>>8)&0xff;
	a.c[3]=(dato)&0xff;
	
	return a.i32;
}

main(int argc, char **argv)
{
	int i,j,fd,base,size,tipo,subt,nf;
	char name[16],ext[16],*p,*pp;
	file_header *pf;
	
	if (argc<2) {
		fprintf(stderr,"Uso: %s <ficheros davinci>\n",argv[0]);
		exit(0);
	}

	// Lectura de fichero imagen
	if ((fd=open(IMAGE,O_RDONLY))==-1) { perror("open"); exit(1);}
	read(fd,mem,0x100000);
	close(fd);
	
	// Bsqueda de espacio libre
	i=0xffffb;
	while(mem[i]==0xff) i--;
	i++; i+=0xffff; i&=0xffff0000;
	base=i;
	i+=BASE;
	//mem[0xfffff]=i&0xff;
	//mem[0xffffe]=(i>>8)&0xff;
	//mem[0xffffd]=(i>>16)&0xff;
	//mem[0xffffc]=(i>>24)&0xff;
	printf("Direccin base: 0x%x ",i);
	i=(0xffffc-base)>>10;
	printf(" %d Kb disponibles\n",i);
		
	for (nf=1;nf<argc;nf++) {
		// Buscamos extensin
		p=argv[nf];
		p+=strlen(argv[nf]);
		while(*p!='.' && p>argv[nf]) p--;
		if (p==argv[nf]) {
			fprintf(stderr,"%s descartado\n",argv[nf]);
			continue;
		}
		p++; strcpy(ext,p); p--;
		
		// Buscamos directorio (/) y copiamos nombre
		pp=argv[nf];
		pp+=strlen(argv[nf]);
		while(*pp!='/' && pp>=argv[nf]) pp--;
		pp++;
		for(i=0;i<15;i++) {
			if (pp==p) break;
			name[i]=*pp++;
		}
		name[i]=0;
		
 		
		// Busqueda de tipo
		
		for(i=0;fidt[i].ext;i++) {
			if (strcmp(ext,fidt[i].ext)==0) break;
		}
		if (fidt[i].ext==NULL) continue;
		tipo=fidt[i].tipo;
		subt=fidt[i].subt;
		
		if((fd=open(argv[nf],O_RDONLY))==-1) {perror("open"); exit(1);}
		size=lseek(fd,0,SEEK_END);
		lseek(fd,0,SEEK_SET);

		//test
		p="?";
		if (tipo==BINARY_CODE) p=bin_code_type[subt];
		if (tipo==TEXT) p=txt_type[subt];
		if (tipo==GRAPHIC) p=gr_type[subt];
		
		printf("%16s (%14s) (%14s) %3d Kb @ 0x%x\n",
			name,long_file_type[tipo],p,(size+1023)>>10,
			base+BASE);
			
		if (0xffffc-base < size+sizeof(file_header)) {
			fprintf(stderr,"Descartado por espacio insuficiente\n");
			close(fd);
			continue;
		}
		pf=(file_header*)&mem[base];
		pf->magic=toBE(FILE_MAGIC);
		pf->size=toBE(size);
		pf->type=tipo;
		pf->subtype=subt;
		strcpy(pf->name,name);
		
		base+=sizeof(file_header);
		read(fd,&mem[base],size);
		base+=size;
		if(size&1) base++;	// Alineacin par
		close(fd);
	}
	
	if((fd=creat(IMAGE,0666))==-1) {perror("creat"); exit(1);}
	write(fd,mem,0x100000);
	close(fd);
	
}

