#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>

#define ROMBASE	0x10c00000
#define ROMLEN	0x00100000

unsigned char mem[ROMLEN];

main(int argc,char **argv)
{
	int i,fd;

	if(argc<3) {
		printf("Uso: %s <fich.BIN> <fich.rom>\n",argv[0]);
		exit(0);
	}
	
	for (i=0;i<ROMLEN;i++) mem[i]=0xff;
	
	if((fd=open(argv[2],O_RDONLY))==-1) {perror("open"); exit(1);}
	read(fd,mem,ROMLEN);
	close(fd);

	if((fd=creat(argv[1],0666))==-1) {
		perror("creat");
		exit(1);
	}
	
	for (i=ROMLEN-1;i;i--) if (mem[i]!=0xff) break;
	i+=0xffff; i&=0xffff0000;	// alineamos a 64Kb
	
	write(fd,&mem[0x10000],i-0x10000);
	close(fd);
}
