	.text

| Secondary bootloader

	move.w	#0x2700,%sr		| IRQ off
	movea.l	#0x40000,%sp		| For routine calling

	moveq	#'@',%d0
	bsr	putch

	move.w	#0x2400,0xFFFFF200	| Prescaler x1 (LCD, UART)
	move.w	#0x0038,0xFFFFF902	| Put UART at 115200 baud

buc0:	bsr	getch			| Wait for 0x55
	cmpi.b	#0x55,%d0
	bne	buc0

	bsr	ferase			| borramos chip
	moveq   #'@',%d0
	bsr     putch			| ACK

	lea.l	0x10c10000,%a5		| Puntero de grabacion

buc1:	move.w	#255,%d7		| Leemos un bloque de 256 bytes
	lea.l	buffer,%a0
buc2:	bsr	getch
	move.b	%d0,(%a0)+
	dbf	%d7,buc2

	move.w	#127,%d7		| Programamos las 128 palabras en flash
	lea.l   buffer,%a0
buc3:	move.w	(%a0)+,%d0
	cmpi.w	#0xffff,%d0
	beq	sig1
	bsr	fprog
sig1:	lea.l	2(%a5),%a5
	dbf	%d7,buc3

	moveq   #'@',%d0
	bsr     putch			| ACK

	bra	buc1

|***	ferase

ferase:	lea.l	0x10c00000,%a1		|Base de la flash	
	move.w	#0xaaaa,0xaaa(%a1)	|Comando Chip erase
	move.w	#0x5555,0x554(%a1)
	move.w	#0x8080,0xaaa(%a1)
	move.w	#0xaaaa,0xaaa(%a1)
	move.w	#0x5555,0x554(%a1)
	move.w	#0x1010,0xaaa(%a1)
	lea.l   0x10c10000,%a1
delera:	cmp.b	#0xff,1(%a1)  		|Esperamos por el borrado
	bne	delera
	move.w	#0xf0f0,(%a1);		|Comando reset
	rts

|***	fprog

fprog:	lea.l	0x10c00000,%a1		|Base de la flash
	move.w	#0xaaaa,0xaaa(%a1)	|Comando Program
	move.w	#0x5555,0x554(%a1)
	move.w	#0xa0a0,0xaaa(%a1)
	move.w	%d0,(%a5)
delpro:	move.b  1(%a5),%d1			|Esperamos D7_Flash == D7_dato
	eor.b	%d0,%d1
	bmi	delpro
	move.w  #0xf0f0,(%a1);          |Comando reset
	rts

|***    UART -> D0.b

getch:  move.w  0xfffff904,%d0
        btst.l  #13,%d0
        beq     getch
        rts

|***	D0.b -> UART

putch:  btst.b  #5,0xfffff906
        beq     putch
        move.b  %d0,0xfffff907
putch1:	btst.b	#7,0xfffff906
	beq	putch1
        rts

buffer:
