#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
//#include <termios.h>
#include <asm/termios.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

#define DEV "/dev/serial0"

int fd=0;

typedef struct{
	int type;
	int nbytes;
	int chk;
	unsigned long address;
	unsigned char *data;
} Srec;

int gethex(char *p)
{
	int i,j;
	if (!isxdigit(*p)) return -1;
	if (*p>='a') i=10+(*p)-'a';
	else if (*p>='A') i=10+(*p)-'A';
	else i=(*p)-'0';
	p++;
	if (!isxdigit(*p)) return -1;
	if (*p>='a') j=10+(*p)-'a';
	else if (*p>='A') j=10+(*p)-'A';
	else j=(*p)-'0';
	return (i<<4)|j;
}


Srec *rd_srec(FILE *fp)
{
	static Srec s;
	static unsigned char dat[1024];
	char buf[2048];
	int i,t,na;
	char *p;
	
	s.data=dat;
	fgets(buf,528,fp);
	if (feof(fp)) { s.chk=1; return &s; }
	p=buf;
	if (*p++!='S') { s.chk=1; return &s; }
	if (!isdigit(*p)) { s.chk=1; return &s; }
	s.type=*(p++)-'0';
	if (s.type==0) { s.chk=0; s.nbytes=0;  return &s; }
	if (s.type<4) na=1+s.type;
	if (s.type>6) na=11-s.type;
	if (s.type >3 && s.type <7) {s.chk=0; s.nbytes=0;  return &s; }
	s.chk=0;

	/*       Lectura Nbytes		*/
	s.nbytes=gethex(p); p+=2;
	s.chk+=s.nbytes;
	s.nbytes-=na+1;
	if (s.nbytes<0) { s.chk=1; return &s; }

	/*       Lectura Address         */

	s.address=0;
	for (i=0;i<na;i++) {
		t=gethex(p); p+=2;
		s.chk+=t;
		if (t<0) { s.chk=1; return &s; }
		s.address<<=8;
		s.address|=t;
	}
	
	/*	Lectura de datos	*/
	
	for (i=0;i<s.nbytes;i++) {
		t=gethex(p); p+=2;
		s.chk+=t;
		if (t<0) { s.chk=1; return &s; }
		dat[i]=t;
	}
	
	/*	Comprobacin de checksum	*/
	
	t=gethex(p);
	s.chk+=t;
	s.chk&=0xff;
	s.chk-=0xff;
	
	return &s;
}


void bootld(unsigned char *a)
{
	int i;
	unsigned char b,*c;
	
	c=a;
	i=strlen(a)-6;
	write(fd,a,1); a++;
	write(fd,a,1); a++;
	write(fd,a,1); a++;
	write(fd,a,1); a++;
	write(fd,a,1); a++;
	write(fd,a,1); a++;
	
	for (;i;i--) {
		write(fd,a,1);
		read(fd,&b,1);
		if (b!=*(a-6)) {
			printf("\nError en bootload a=%02x(%c) b=%02X(%c)\n",
				*(a-1),*(a-1),b,b);
			printf(">%s<\n",c);
			exit(1);
		}
		a++;
	}
	read(fd,&b,1);
	read(fd,&b,1);
	read(fd,&b,1);
	read(fd,&b,1);
	read(fd,&b,1);
	read(fd,&b,1);
	
}

void set_baudios(int baud)
{
	struct termios term;
	int result;

	if (fd) close(fd);
	if ((fd=open(DEV,O_RDWR))==-1) exit(1);

	usleep(200000);

	/* ponemos las cosas del puerto en su sitio */
	tcgetattr(fd,&term);

	term.c_cflag&=~CBAUD;
	term.c_cflag|=baud;
	term.c_cflag&=~CSIZE;
	term.c_cflag|=CS8;
	term.c_cflag|=CSTOPB;
	term.c_cflag&=~PARENB;
	
	term.c_lflag&=~ICANON;
	term.c_lflag&=~ECHO;
	term.c_lflag&=~ISIG;
	term.c_iflag&=~ICRNL;
	term.c_iflag&=~IXOFF;
	term.c_iflag&=~IXON; 
/*	term.c_cflag|=TIOCM_RI; */
	term.c_oflag&=~OPOST;
	
	if (tcsetattr(fd,TCSANOW,&term)) {
		fprintf(stderr,"Fallo en tcsetattr\n");
		exit(0);
	}


	/* Damos alimentacin al cradle */

	result=0;
	result|=TIOCM_DTR;
	ioctl (fd, TIOCMBIS, &result);

	result=0;
	result|=TIOCM_RTS;
	ioctl (fd, TIOCMBIC, &result);
	
	usleep(200000);
	
}

unsigned char mem[0x100000];

main(int argc,char **argv)
{
	unsigned char a,buf[256];
	int i,j,k,fdf;
	char rotor[4]={'-','\\','|','/'};
	FILE *fp;
	Srec *sp;


	set_baudios(B9600);
	
	/**** Esperamos que el 68ez328 est listo ****/
	
	printf("Esperando arranque del daVinci en modo bootloader...\n");
	for(k=0;;k++) {
		a='\r';
		write(fd,&a,1);
		usleep(100000);
		i=fcntl(fd,F_GETFL);
		fcntl(fd,F_SETFL,i|O_NONBLOCK);
		j=read(fd,&a,1);
		fcntl(fd,F_SETFL,i);
		if (j>0 && a=='@') break;
		printf("\r%c",rotor[k&3]); fflush(stdout);
	}
	printf("\rOK\n");

/************* Inicializacion bsica ****************/

	printf("Inicializacion bsica ..."); fflush(stdout);

//	bootld("FFFFF1180130\n");	//emucs init
	bootld("FFFFF000011C\n");	//SCR init
	bootld("FFFFFB0A0100\n");	//Disable WD
//	bootld("FFFFF42B0183\n");	//Enable clko
	bootld("FFFFF40B0140\n");	//Enable chip select
	bootld("FFFFFD0D0108\n");	//disable hardmap
//	bootld("FFFFFD0E0107\n");	//clear level 7 interrupt

	/**** Programamos Registros del 68ez328 ****/

//	bootld("FFFFF000011C\n");	//System control
	bootld("FFFFF42B0105\n");	//PF Select

	bootld("FFFFF100028600\n");	//Group A base (Flash 1)
	bootld("FFFFF110020097\n");	//CSA0
	bootld("FFFFF102028000\n");	//Group B base (RAM)
	bootld("FFFFF112020083\n");	//CSB0
	bootld("FFFFF104020000\n");	//Group C base (RAM)
	bootld("FFFFF114020087\n");	//CSC0
	bootld("FFFFF106028200\n");	//Group D base (Flash 2);
	bootld("FFFFF11602009B\n");	//CSD0

	
	bootld("FFFFFA270100\n");	//LCD CLK off
	bootld("FFFFFA000400001000\n");	//LCD start address
	bootld("FFFFFA05010A\n");	//LCD virtual width
	bootld("FFFFFA080200A0\n");	//LCD screen width
	bootld("FFFFFA0A02009F\n");	//LCD screen height
	bootld("FFFFFA200108\n");	//LCD interf. conf.
	bootld("FFFFFA290180\n");	//LCD last buffer address
	bootld("FFFFFA250106\n");	//LCD pixel CLK divider
	bootld("FFFFFA210100\n");	//LCD pixel polarity
	bootld("FFFFFA1F0100\n");	//LCD blink control
	bootld("FFFFFA270181\n");	//LCD CLK control

	bootld("FFFFF4130100\n");	//PC select
	bootld("FFFFF4120100\n");	//PC pull-down
	bootld("FFFFF4090140\n");	//PB DATA
	bootld("FFFFF4080140\n");	//PB DIR
	bootld("FFFFF40A01BF\n");	//PB Pull-up
	bootld("FFFFF42A01FA\n");	//PF Pull-up
	bootld("FFFFF4280105\n");	//PF DIR
	bootld("FFFFF42B0105\n");	//PF Select
	bootld("FFFFF4290104\n");	//PF DATA
	bootld("FFFFF40A0100\n");	//PB Pull-up
	bootld("FFFFF42A0102\n");	//PF Pull-up

	printf("OK\n");
	
/************  Cargamos bootloader secundario **************/

printf("Cargando bootloader secundario..."); fflush(stdout);

if ((fp=fopen("linuxland/flashboot.brec","r"))==NULL) {
	perror("fopen flashboot.brec");
	exit(1);
}

for (;;) {
	fgets(buf,256,fp);
	if (feof(fp)) break;
	bootld(buf);
}
fclose(fp);

printf("OK\n");
/************  Pasamos el fichero imagen ROM al nuevo bootloader **********/

	set_baudios(B115200);

	printf("Fase 2...\n"); 
	if((fdf=open(argv[1],O_RDONLY))==-1) {
		perror("open");
		exit(1);
	}
	k=read(fdf,mem,0xF0000);
	close(fdf);

	printf("Borrando Flash...\n");
	a=0x55; write(fd,&a,1); /* start */
	read(fd,&a,1);
	if (a!='@') {
		perror("ACK");
		exit(2);
	} else printf("Flash Borrada\n");
	
	//for (k=0x0fffff;k;k--) if (mem[k]!=0xff) break;

	k=(k+255)&0xffffff00;
	
	for (i=0;i<k;i+=256) {
		write(fd,&mem[i],256);
		read(fd,&a,1);
		if (a!='@') {
			perror("ACK");
			exit(2);
		} else {printf("%x\r",i+0x10c10000); fflush(stdout);}
	}

	printf("\nOK\n");

}

