#include "common.h"
#include "vt.h"
#include "lcd.h"
#include "task.h"
#include "bit.h"

extern vt vt_table[];
extern vt *cur_vt;
extern TSS *cur_task;
extern void _data;

/*------------------ PANTALLA ----------------------*/

/* Variables globales */
const unsigned char font[]=
#include "iso01a-8x8.hex"

void set_screen_base(char *p)
{
        if ((int)p>(int)&_data && (int)p<(int)&_data+0x20000) p=&p[0x800000];
        *(volatile unsigned long *)0xfffffa00=(unsigned long)p;
}

char *get_screen_base()
{
	//return (char *)*(volatile unsigned long *)0xfffffa00;
        return cur_vt->screen_base;
}

int set_video_mode(unsigned short modo)
{
	static const char lcdccr[3]={6,3,1};
	static const char lblkc[3]={7,14,42};
	if (modo>2) return -1;
	*(volatile unsigned char *)0xfffffa20=8+modo;
	*(volatile unsigned char *)0xfffffa25=lcdccr[modo];
	*(volatile unsigned char *)0xfffffa29=0x00;
	*(volatile unsigned char *)0xfffffa31=0xD9;
	*(volatile unsigned char  *)0xfffffa1f=0x80+lblkc[modo];
	return 0;
}

void set_cursor(vt *pvt)
{
    if (pvt==(vt *)0) pvt=cur_task->vt;
    if (pvt==cur_vt) {
	*(volatile unsigned short *)0xfffffa18=0x4000+(((unsigned short)pvt->p_x)<<3);
	*(volatile unsigned short *)0xfffffa1a=(((unsigned short)pvt->p_y)<<3)+5;
	*(volatile unsigned short *)0xfffffa1c=0x0804;
	*(volatile unsigned char  *)0xfffffa1f|=0x80;
    }
    pvt->cursor_st=1;
}

void cursor_off(vt *pvt)
{
	if (pvt==(vt *)0) pvt=cur_task->vt;
	if (pvt==cur_vt) *(volatile unsigned short *)0xfffffa18&=0x3fff;
	pvt->cursor_st=0;
}

void cursor_on(vt *pvt)
{
	if (pvt==(vt *)0) pvt=cur_task->vt;
	if (pvt==cur_vt) *(volatile unsigned short *)0xfffffa18|=0x4000;
	pvt->cursor_st=1;
}

void wrchar(int x, int y, unsigned char a)
{
	short i;
	static const unsigned char t2bpp[16]={
	  0x00,0x03,0x0c,0x0f,0x30,0x33,0x3c,0x3f,
	  0xc0,0xc3,0xcc,0xcf,0xf0,0xf3,0xfc,0xff
	};
	static const unsigned short t4bpp[16]={
	  0x0000,0x000f,0x00f0,0x00ff,0x0f00,0x0f0f,0x0ff0,0x0fff,
	  0xf000,0xf00f,0xf0f0,0xf0ff,0xff00,0xff0f,0xfff0,0xffff
	};
	unsigned char *pp,*pf;
	unsigned short *ps;
	vt *pvt;

        if ((pvt=cur_task->vt)==(vt *)0) return;
	if (x<0 || x>19) return;
	if (y<0 || y>19) return;

	pf=(unsigned char *)font;
	pf+=((unsigned int)a)<<3;

	pp=pvt->screen_base;
	pp+=(y*160+x)<<pvt->video_mode;
	ps=(unsigned short *)pp;
	switch(pvt->video_mode) {
	case 0:	for (i=8;i;i--) {
		  *pp=*pf++;
		  pp+=20;
		}
		break;
	case 1: for (i=8;i;i--) {
		  *pp++=t2bpp[(*pf)>>4];
		  *pp=t2bpp[(*pf++)&0xf];
		  pp+=39;
		}
		break;
	case 2: for (i=8;i;i--) {
		  *ps++=t4bpp[(*pf)>>4];
		  *ps=t4bpp[(*pf++)&0xf];
		  ps=&ps[39];
		}
		break;
	}
}

void lcd_putch(char a)
{
	vt *pv;
	int *ps,*pd,i;

        if (cur_task->vt==(vt *)0) return;
	pv=cur_task->vt;

        switch(a) {
	case '\n':	pv->p_x=0;
			pv->p_y++;
			break;
	case '\r':	pv->p_x=0;
			break;
	case '\t':	pv->p_x+=4;
			pv->p_x&=~3;
			break;
	case 127:
	case 8:		if (pv->p_x>0) pv->p_x--;
			wrchar(pv->p_x,pv->p_y,' ');
			break;
	default:	wrchar(pv->p_x,pv->p_y,a);
			pv->p_x++;
			break;
	}
	if (pv->p_x>19) {
		pv->p_x=0;
		pv->p_y++;
	}
	if (pv->p_y>19) {	//*****scroll*****
		pv->p_y=19;
		//pd=*((unsigned int **)0xfffffa00);
		pd=(unsigned int *) pv->screen_base;
		ps=pd+40;
		for (i=760;i;i--) *pd++=*ps++;
		for (i=40;i;i--) *pd++=0;
	}

	set_cursor(pv);
}

void gotoxy(short x,short y)
{
	vt *pv;
	if (cur_task->vt==(vt *)0) return;
	pv=cur_task->vt;

	pv->p_x=x; pv->p_y=y;
	set_cursor(pv);
}

void cls()
{
	int *p,i;
	vt *pv;
	if (cur_task->vt==(vt *)0) return;
	pv=cur_task->vt;

	p=(int *) pv->screen_base;
	for (i=(800<<pv->video_mode);i;i--) *p++=0;
	pv->p_x=pv->p_y=0;
	set_cursor(pv);
}


/**************************** Funciones Grficas ******************************/
/* Funcin maestra */

void putpixel(int x, int y, int pix)
{
	unsigned char *p,mask,fr;
	int pixel,dir;

	if (x<0 || x>159) return;
	if (y<0 || y>159) return;

	p=cur_task->vt->screen_base;
	pixel=(y<<7)+(y<<5)+x;
	switch(cur_task->vt->video_mode) {
	case 0:	if (pix) bit_set(p,pixel^7);
		else bit_clr(p,pixel^7);
		break;
	case 1:	dir=pixel>>2; fr=((pixel&3)^3)<<1;
		mask=3<<fr; pix&=3;
		p[dir]&=~mask; p[dir]|=pix<<fr;
		break;
	case 2:	dir=pixel>>1; fr=((pixel&1)^1)<<2;
		mask=0xf<<fr; pix&=0xf;
		p[dir]&=~mask; p[dir]|=pix<<fr;
		break;
	default:
		return;
	}
}

/********************************************/

void line (int comienzax,int comienzay,int finx,int finy,int color)
{
	int t,distancia;
	int xerr=0,yerr=0,delta_x,delta_y;
	int incx,incy;
	delta_x=finx-comienzax;
	delta_y=finy-comienzay;

	if (delta_x>0) incx=1;
	else if (delta_x==0) incx=0;
	else incx=-1;

	if (delta_y>0) incy=1;
	else if (delta_y==0) incy=0;
	else incy=-1;

	delta_x=abs(delta_x);
	delta_y=abs(delta_y);
	if (delta_x>delta_y) distancia =delta_x;
	else distancia=delta_y;

	for (t=0;t<distancia+1;t++) {
		putpixel(comienzax,comienzay,color);
		xerr+=delta_x;
		yerr+=delta_y;
		if (xerr>distancia) {
			xerr-=distancia;
			comienzax+=incx;
		}
		if (yerr>distancia) {
			yerr-=distancia;
			comienzay+=incy;
		}
	}
}

/*--------------------- Lneas horizontales aceleradas ----------------------*/
/*---------------- Se intentan escribir los pixels de 8 en 8 ----------------*/

void hline(int x0,int x1, int y, int color)
{
    vt *pvt;
    int i,xa,xc,n;
    char *pc,cc;
    short *ps,cs;
    long *pl,cl;

    static const char  fill1[2]={0x00,0xff};
    static const short fill2[4]={0x0000,0x5555,0xaaaa,0xffff};
    static const long fill4[16]={0x00000000,0x11111111,0x22222222,0x33333333,
    			  0x44444444,0x55555555,0x66666666,0x77777777,
    			  0x88888888,0x99999999,0xaaaaaaaa,0xbbbbbbbb,
    			  0xcccccccc,0xdddddddd,0xeeeeeeee,0xffffffff};

	if (y<0) y=0; if (y>159) y=159;
	if (x0<0) x0=0; if (x0>159) x0=159;
	if (x1<0) x1=0; if (x1>159) x1=159;


    pvt=cur_task->vt;

    if (x0==x1) { putpixel(x0,y,color); return; }
    if (x0&7) {	// Existe tramo A
	if ((x0>>3)==(x1>>3)) {	//Solo tramo A
	    for (i=x0;i<=x1;i++) putpixel(i,y,color);
	    return;
	} else {
	    n=(x0+7)&0xf8;
	    for (i=x0;i<n;i++) putpixel(i,y,color);
	}
    }
    xa=(x0+7)&0xf8;
    xc=(x1+1)&0xf8;
    n=(xc-xa)>>3;	// Tramo B: acelerado (8 pixel de cada vez)
    if (n) {
	switch(pvt->video_mode) {
	case 0:	pc=(char *) pvt->screen_base;
		pc=&pc[y*20+(xa>>3)]; cc=fill1[color&1];
		for (;n;n--) *pc++=cc;
		break;
	case 1:	ps=(short *) pvt->screen_base;
		ps=&ps[y*20+(xa>>3)]; cs=fill2[color&3];
		for (;n;n--) *ps++=cs;
		break;
	case 2:	pl=(long *) pvt->screen_base;
		pl=&pl[y*20+(xa>>3)]; cl=fill4[color&15];
		for (;n;n--) *pl++=cl;
		break;
	}
    }
    if ((x1+1)==xc) return; // No hay tramo C
    for (i=xc;i<=x1;i++) putpixel(i,y,color);
}

/*---------------------- Lineas Verticales Aceleradas ------------------------*/

void vline(int x,int y0,int y1,int color)
{
	unsigned char *pc,mask,pix;
	int paso,i;
	if (x<0) x=0; if (x>159) x=159;
	if (y0<0) y0=0; if (y0>159) y0=159;
	if (y1<0) y1=0; if (y1>159) y1=159;

	pc=cur_task->vt->screen_base;
	switch(cur_task->vt->video_mode){
	case 0:	pc=&pc[y0*20+(x>>3)];
		mask=0x80>>(x&7);
		color&=1;
		pix=(color<<7)>>(x&7);
		paso=20;
		break;
	case 1:	pc=&pc[y0*40+(x>>2)];
		mask=0xC0>>((x&3)<<1);
		color&=3;
		pix=(color<<6)>>((x&3)<<1);
		paso=40;
		break;
	case 2:	pc=&pc[y0*80+(x>>1)];
		mask=0xF0>>((x&1)<<2);
		color&=15;
		pix=(color<<4)>>((x&1)<<2);
		paso=80;
		break;
	}
	for (i=y0;i<=y1;i++) {
		*pc &= ~mask;
		*pc |= pix;
		pc=&pc[paso];
	}
}

/*----------------------------------------------------------------------------*/

void punto_circulo(int x,int y,int centrox,int centroy,int color)
{
	putpixel(centrox+x,centroy+y,color);
	putpixel(centrox-x,centroy+y,color);
	putpixel(centrox+x,centroy-y,color);
	putpixel(centrox-x,centroy-y,color);

	putpixel(centrox+y,centroy+x,color);
	putpixel(centrox-y,centroy+x,color);
	putpixel(centrox+y,centroy-x,color);
	putpixel(centrox-y,centroy-x,color);
}

void punto_fcirculo(int x,int y,int centrox,int centroy,int color)
{
	hline(centrox-x,centrox+x,centroy+y,color);
	hline(centrox-x,centrox+x,centroy-y,color);

	hline(centrox-y,centrox+y,centroy+x,color);
	hline(centrox-y,centrox+y,centroy-x,color);
}

void circle (int centrox,int centroy,int radio,int color)
{
	int x,y,delta;

	y=radio;
	delta=3-(radio<<1);
	for (x=0;x<y;) {
		punto_circulo(x,y,centrox,centroy,color);
		if (delta<0)
			delta+=(x<<2)+6;
		else {
			delta+=(((x-y)<<2)+10);
			y--;
		}
		x++;
	}
	x=y;
	if (y) punto_circulo(x,y,centrox,centroy,color);
}

void filled_circle (int centrox,int centroy,int radio,int color)
{
	int x,y,delta;

	y=radio;
	delta=3-(radio<<1);
	for (x=0;x<y;) {
		punto_fcirculo(x,y,centrox,centroy,color);
		if (delta<0)
			delta+=(x<<2)+6;
		else {
			delta+=(((x-y)<<2)+10);
			y--;
		}
		x++;
	}
	x=y;
	if (y) punto_fcirculo(x,y,centrox,centroy,color);
}

void rectangle(int x0,int y0, int x1, int y1, int color)
{
	int i;

	hline(x0,x1,y0,color);
	hline(x0,x1,y1,color);
	vline(x0,y0,y1,color);
	vline(x1,y0,y1,color);
}

void filled_rectangle(int x0,int y0, int x1, int y1, int color)
{
	int i,j;

	for (i=y0;i<=y1;i++) {
		//for (j=x0;j<=x1;j++) putpixel(j,i,color);
		hline(x0,x1,i,color);
	}
}

