#include "common.h"
#include "task.h"
#include "mem.h"
#include "fifo.h"
#include "vt.h"
#include "pen.h"
#include "klib.h"
#include "lcd.h"
#include "lowio.h"
#include "file.h"
#include "audio.h"
#include "time.h"
#include "dct.h"
#include "syscall.h"


#define MAXPAR 6

extern void _buser;
extern unsigned int ticcnt;
extern TSS *cur_task;
extern vt *cur_vt;

int ksyscall(int *ppar)
{
	int r;
	long long *pll;

	if ((unsigned int)ppar<(unsigned int)(&_buser) ||
	    ((unsigned int)ppar)+MAXPAR*4 > ((unsigned int)&_buser)+U_RAM_SZ)
	    return -1;
	if (ppar[0]<0 || ppar[0]>=LASTCALL) return -1;

	switch(ppar[0]) {
	case TASK_EXIT:		task_exit(); 			return 0;
	case TASK_SLEEP:	task_sleep(ppar[1]); 		return 0;
	case KMALLOC:		return (int)kmalloc(U_RAM,ppar[1]);
	case KFREE:		return kfree((char *)ppar[1],ppar[2]);
	//case FIFO_GET:		return fifo_get((fifo *)ppar[1]);
	//case FIFO_GETNB:	return fifo_getnb((fifo *)ppar[1]);
	//case FIFO_FLUSH:	fifo_flush((fifo *)ppar[1]); 	return 0;
	case OPEN_VT:		return (int)open_vt(ppar[1],0);
	case CLOSE_MY_VT:	close_my_vt(); 			return 0;
	case VT_TO_FG:		if (cur_task->vt) switch_vt(cur_task->vt);
				return 0;
	case VT_GET_EVENT:	return fifo_get(cur_task->vt->event);
	case VT_GET_EVENT_NB:	return fifo_getnb(cur_task->vt->event);
	case VT_GET_SCREEN_BASE:return (int)cur_task->vt->screen_base;
	case VT_SET_SCREEN_BASE:
				if(!(cur_task->vt)) return -1;
				cur_task->vt->screen_base=(char *)ppar[1];
				if(cur_task->vt==cur_vt){
					set_screen_base((char *)ppar[1]);
				}
				return 0;
	case PUTCHAR:		lcd_putch(ppar[1]);		return 0;
	case PUTS:		kputs((char *)ppar[1]);		return 0;
	case CURSOR_OFF:	if(cur_task->vt) cursor_off(cur_task->vt);
				return 0;
	case CURSOR_ON:		if(cur_task->vt) cursor_on(cur_task->vt);
				return 0;
	case GOTOXY:		gotoxy(ppar[1],ppar[2]);	return 0;
	case CLS:		cls();				return 0;
	case PUTPIXEL:		putpixel(ppar[1],ppar[2],ppar[3]); return 0;
	case LINE:		line(ppar[1],ppar[2],ppar[3],ppar[4],ppar[5]);
				return 0;
	case HLINE:		hline(ppar[1],ppar[2],ppar[3],ppar[4]);
				return 0;
	case VLINE:		vline(ppar[1],ppar[2],ppar[3],ppar[4]);
				return 0;
	case CIRCLE:		circle(ppar[1],ppar[2],ppar[3],ppar[4]);
				return 0;
	case FILLED_CIRCLE:	filled_circle(ppar[1],ppar[2],ppar[3],ppar[4]);
				return 0;
	case RECTANGLE:		rectangle(ppar[1],ppar[2],ppar[3],ppar[4],ppar[5]);
				return 0;
	case FILLED_RECTANGLE:	filled_rectangle(ppar[1],ppar[2],ppar[3],ppar[4],ppar[5]);
				return 0;
	case GET_PEN_XY:	return get_pen_xy((short *)ppar[1],(short *)ppar[2]);
	case SOUND:		sound(ppar[1],ppar[2]); 	return 0;
	case SOUND_VOL:		sound_vol(ppar[1]);		return 0;
	case SOUND_OFF:		sound_off();			return 0;
	case RDTSC:		return ticcnt;
	case FILE_SEL_IX:	return (int)file_sel_ix(ppar[1],ppar[2],ppar[3]);
	case FILE_SEL_NEXT:	return (int)file_sel_next(ppar[1],ppar[2],(file_header *)ppar[3]);
	case FILE_GET_NFILES:	return file_get_nfiles(ppar[1],ppar[2]);
	case FILE_SEL_INT:	return file_sel_int(ppar[1],ppar[2],ppar[3]);

	case AUDIO_START:	return audio_start((char *)ppar[1],ppar[2]);
	case AUDIO_STOP:	audio_stop(); return 0;
	case AUDIO_MEAS_FREC:	return audio_mide_frec();
	case TASK_GET_TIME:	pll=(long long *)ppar[1];
				if (check_mem_range((unsigned char *)pll,sizeof(long long)))
					return -1;
				*pll=cur_task->clks;
				return 0;
	case PWM_START:		return pwm_start((char *)ppar[1],ppar[2]);
	case PWM_STOP:		pwm_stop(); return 0;
        case TIME_GET_RTC:      if (check_mem_range((unsigned char *)ppar[1],sizeof(time))) return -1;
                                get_time((time *)ppar[1],0); return 0;
        case ZIP_GET_DCT_ADDRESS:
                                return (int) dct_showimage;

	default:		return -1;
	}
}

