#include "keyboard.h"


int key_to_ascii(int key)
{

	static const unsigned char tb_key[60][4]={
//	Normal	MAY	Shift	Alt
	'1',	'1',	'!',	'|',
	'2',	'2',	'\"',	'@',
	'3',	'3',	'#',	'',
	'4',	'4',	'$',	'',
	'5',	'5',	'%',	'',
	'6',	'6',	'&',	'',
	'7',	'7',	'/',	'',
	'8',	'8',	'(',	'',
	'9',	'9',	')',	'9',
	'0',	'0',	'=',	'',
	'\'',	'\'',	'?',	'\\',
	'+',	'+',	'*',	'',
	8,	8,	8,	8,
	'q',	'Q',	'Q',	'q',
	'w',	'W',	'W',	'',
	'e',	'E',	'E',	'',
	'r',	'R',	'R',	'',
	't',	'T',	'T',	't',
	'y',	'Y',	'Y',	'y',
	'u',	'U',	'U',	'u',
	'i',	'I',	'I',	'i',
	'o',	'O',	'O',	'',
	'p',	'P',	'P',	'',
	'{',	'{',	'[',	'',
	'}',	'}',	']',	'',
	10,	10,	10,	10,

//	Normal	MAY	Shift	Alt
	9,	9,	9,	9,
	'a',	'A',	'A',	'',
	's',	'S',	'S',	's',
	'd',	'D',	'D',	'',
	'f',	'F',	'F',	'f',
	'g',	'G',	'G',	'g',
	'h',	'H',	'H',	'h',
	'j',	'J',	'J',	'j',
	'k',	'K',	'K',	'k',
	'l',	'L',	'L',	'',
	'',	'',	'',	'~',
	0,	0,	1,	2,	//acentos
	10,	10,	10,	10,
	'<',	'<',	'>',	'<',
	'z',	'Z',	'Z',	'',
	'x',	'X',	'X',	'x',
	'c',	'C',	'C',	'',
	'v',	'V',	'V',	'v',
	'b',	'B',	'B',	'',
	'n',	'N',	'N',	'n',
	'm',	'M',	'M',	'',
	',',	',',	';',	',',
	'.',	'.',	':',	'.',
	'-',	'-',	'_',	'',
	K_U,	K_U,	K_U,	K_U,
	0,	0,	0,	0,	// shift

//	Normal	MAY	Shift	Alt
	0,	0,	0,	0,	// Maysculas
	0,	0,	0,	0,	// shift
	' ',	' ',	' ',	' ',
	0,	0,	0,	0,	// Crtl
	0,	0,	0,	0,	// Alt
	K_L,	K_L,	K_L,	K_L,
	K_D,	K_D,	K_D,	K_D,
	K_R,	K_R,	K_R,	K_R
	};

	static const unsigned short tb_acc[6][3]={
	'\'',	'^',	'',
	'',	'',	'',
	'',	'',	'',
	'',	'',	'',
	'',	'',	'',
	'',	'',	''
	};

	int ascii,i;
	static unsigned char kst=K_NOR,kmay=0;

	switch(key) {
		case 51:
		case 53:	kst=K_SHF;	return -1;
		case 52:	kmay^=1;	return -1;
		case 55:	kst=K_CNT;	return -1;
		case 56:	kst=K_ALT;	return -1;
		case 37:	kst=K_ACC0+tb_key[37][kst&3]; return -1;
		default:
				if (kst>=K_ACC0) {
					switch(key) {
					case 54: ascii=tb_acc[0][kst-K_ACC0];
						 break;
					case 27: ascii=tb_acc[1][kst-K_ACC0];
						 break;
					case 15: ascii=tb_acc[2][kst-K_ACC0];
						 break;
					case 20: ascii=tb_acc[3][kst-K_ACC0];
						 break;
					case 21: ascii=tb_acc[4][kst-K_ACC0];
						 break;
					case 19: ascii=tb_acc[5][kst-K_ACC0];
						 break;
					default: return -1;
					}
					kst=K_NOR;
					return ascii;
				}
				if (kst==K_CNT) {
					ascii=tb_key[key][1]-64;
					if (ascii<0) return-1;
					kst=K_NOR;
					return ascii;
				}
				if (kst) i=kst; else i=kmay;
				ascii=tb_key[key][i];
				kst=K_NOR;
				return ascii;
	}
}


int xy_to_key(short x, short y)
{
	static const char c5[8]={19,19,65,19,19,13,13,13};
	short fila,col;
	int key;

	if (y>166) {
		fila=(y-167)/12; if (fila>4) fila=4;
		if (fila<4) {
			col=((x+10-8*(fila&1))*10)>>7; if (col>12) col=12;
		} else {
			x+=11;
			for (col=0;col<8;col++) {
				x-=c5[col];
				if (x<=0) break;
			}

		}
		key=fila*13+col;
		
		//kprintf("F=%d C=%d Key=%d\n",fila,col,key);
	} else return -1;

	return key_to_ascii(key);
}
