#include "common.h"
#include "task.h"
#include "fifo.h"
#include "event.h"

extern unsigned short spi(unsigned short);
extern fifo ffevent;

char durmiendo=0;

/* Init the IRQ system */
void init_irq() {
	short i;
	asm volatile ("
	movea.l #0xfffff300,%a0
	move.b	#0x40,(%a0)		| Vector base
	move.w	#0,2(%a0)		| Polarity LOW, Level IRQ's
	move.l	#0x00ebffed,4(%a0)	| MASK: IRQ5,IRQ3,RTC,TMR enabled
	|move.l	#0x00ebfffd,4(%a0)
	move.l	#0xffffffff,0xc(%a0)	| Clear all pending IRQ
	");

	for(i=10;i;i--) {		//limpiamos de int al NEXUS
		spi(0);
		spi(0x40);
		spi(0);
	}

	fifo_flush(&ffevent);	// Inicializamos la cola de eventos

	// Habilita interrupcin de Timer (64 Hz)
	asm volatile ("
	movea.l	#0xfffff600,%a0
	move.w	#0x0113,(%a0)	| freerun, IRQ, prescaler, enable
	move.w	#7,2(%a0)	| prescaler=8 (f=2.072576 MHz)
	move.w	#32384,4(%a0)	| compare	(64 int/seg)
	bclr.b	#0,0xb(%a0)	| COMP=0
	bclr.b	#1,0xb(%a0)	| CAPT=0
	");
	asm volatile ("
	movea.l #0xfffffB00,%a0
	move.w  #0xd,0x10(%a0)		| Habilita stopwatch,alarm,day IRQs
	move.w  #0xffff,0xe(%a0)	| Borra todas las INT's
	");
	asm volatile ("move.w  #0x2000,%sr");	//All IRQ levels enabled

}


/*-------------------------------- Button IRQ -------------------------------*/
void level_3_irq()
{
	static short lbut=0xffff;
	short but,tbut,chbut;
	char i;

	if(durmiendo) {
		asm volatile("move.l  #0x00ffffff,0xfffff304");
		return;
	}
	spi(0x200);
	tbut=but=spi(0x200);
	chbut=lbut^but;

	for (i=0;i<10;i++) {
		if (chbut & 1) break;
		chbut>>=1;
		tbut>>=1;
	}
	if (i<10) {
		i<<=1;
		if (tbut & 1) i++;
		fifo_put(i,&ffevent);
	}
	lbut=but;
}

/*--------------------------- MISC IRQ (UART,RTC) --------------------------*/
void uart_irq();

void level_4_irq()
{
        unsigned short irtc;

	if ((*(volatile unsigned long *)0xfffff30c)&0x4) uart_irq();
	if ((*(volatile unsigned long *)0xfffff30c)&0x10) {	// RTC
          irtc=*(volatile unsigned short *)0xfffffb0e;
          *(volatile unsigned short *)0xfffffb0e=irtc;          //clear IRQ
	  if (irtc&1) fifo_put(EV_GO_OFF,&ffevent); //Stopwatch
          if (irtc&4) fifo_put(EV_ALARM,&ffevent);  //Alarm
          if (irtc&8) fifo_put(EV_DAY,&ffevent);    //Day update
	}
}

/*------------------------------- PEN TAP IRQ ------------------------------*/
void level_5_irq()
{
	short x,y;
	char i;

	if ((*(volatile char *)0xfffff429)&0x2) i=EV_TAP_REL;
	else i=EV_TAP_PRESS;

	fifo_put(i,&ffevent);

	asm volatile ("
	btst.b	#1,0xfffff429
	bne	1f
	bset.b	#7,0xfffff303
	bra	2f
1:	bclr.b	#7,0xfffff303
2:
	");
}

