#include <stdlib.h>
#include <stdio.h>

char *readpgm(char *fn, int *x, int *y){
        int i;
	FILE *fp;
	unsigned char buf[256];
	unsigned char *img;

	if ((fp=fopen(fn,"r"))==NULL) {perror("fopen"); exit(1);}

	//printf("%s\n",fn);

	fgets(buf,256,fp);

	if (strcmp(buf,"P5\n")!=0) {
		fprintf(stderr,"No es fichero PGM/P5\n");
		exit(0);
	}
	do {
		fgets(buf,256,fp);
	} while (buf[0]=='#');
	sscanf(buf,"%d%d",x,y);
	//fprintf(stderr,"X=%d Y=%d\n",X,Y);
	fgets(buf,256,fp);
        if ((i=atoi(buf))>255) {
	        fprintf(stderr,"N de colores no soportado: %d\n",i);
	        exit(0);
        }
	if ((img=malloc((*x)*(*y)))==NULL) {perror("malloc"); exit(1);}
	fread(img,1,(*x)*(*y),fp);
	fclose(fp);
        return img;
}

char *readppm(char *fn, int *x, int *y){
	int i,j;
	FILE *fp;
	unsigned char buf[256],*pd;
	unsigned char *img;

	if ((fp=fopen(fn,"r"))==NULL) {perror("fopen"); exit(1);}

	//printf("%s\n",fn);

	fgets(buf,256,fp);

	if (strcmp(buf,"P6\n")!=0) {
		fprintf(stderr,"No es fichero PPM/P6\n");
		exit(0);
	}
	do {
		fgets(buf,256,fp);
	} while (buf[0]=='#');
	sscanf(buf,"%d%d",x,y);
	//fprintf(stderr,"X=%d Y=%d\n",X,Y);
	fgets(buf,256,fp);
        if ((i=atoi(buf))>255) {
	        fprintf(stderr,"N de colores no soportado: %d\n",i);
	        exit(0);
        }
	if ((img=malloc((*x)*(*y)*4))==NULL) {perror("malloc"); exit(1);}
        pd=img;
        j=(*x)*(*y);
        for (i=0;i<j;i++) {
	        fread(pd,1,3,fp);
                pd[3]=0;
                pd=&pd[4];
        }
	fclose(fp);
        return img;
}


void writepgm(unsigned char *buf, char *fn,int x,int y)
{
        FILE *fp;

        if ((fp=fopen(fn,"w"))==NULL) {perror("fopen"); exit(1);}
        fprintf(fp,"P5\n");
        fprintf(fp,"#CREATOR TILLA\n");
        fprintf(fp,"#version %s\n",VERSION);
        fprintf(fp,"%d %d\n",x,y);
        fprintf(fp,"255\n");

        fwrite(buf,1,x*y,fp);
        fclose(fp);
}

void writeppm(unsigned char *buf, char *fn,int x,int y)
{
        int i;
        FILE *fp;

        if ((fp=fopen(fn,"w"))==NULL) {perror("fopen"); exit(1);}
        fprintf(fp,"P6\n");
        fprintf(fp,"#CREATOR TILLA\n");
        fprintf(fp,"#version %s\n",VERSION);
        fprintf(fp,"%d %d\n",x,y);
        fprintf(fp,"255\n");

        fwrite(buf,1,x*y,fp);
        for (i=0;i<x*y;i++) {
            fwrite(buf,1,3,fp);
            buf=&buf[4];
        }
        fclose(fp);
}
