#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>

void x11_init(int x,int y);
void putpixel(int x,int y,int color);

// PDA screen emulation
unsigned char panta[12800];

void showpanta()
{
        int i,j,k,c;
        for(k=i=0;i<160;i++) {
                for (j=0;j<80;j++) {
                     c=panta[k]>>4;
                     putpixel(j<<1,i,c^0xf);
                     c=panta[k++]&15;
                     putpixel((j<<1)+1,i,c^0xf);
                }
        }
}

void iidct (short* datai, short* datao);

unsigned char bitbuf,*cmpbuf;
int cbit=0;

extern inline int inbit()
{
        int i;
        if (cbit==0){
                bitbuf=*cmpbuf++;
                cbit=8;
        }
        i=bitbuf>>7;
        bitbuf<<=1; cbit--;
        return i;
}

int inbits(int nb)
{
        int i=0;
        for (;nb;nb--) {
                i<<=1;
                if (inbit()) i++;
        }
        return i;
}

int incoef()
{
        int i,n;
        static int nzeros=0;

        if (nzeros) {
                nzeros--;
                return 0;
        }
        n=inbit();
        if (n==0) return n;
        n=inbits(3);
        if(n!=0 && n!=4) {
                if (n<4) return n;
                return n-8;
        }
        if (n==4) {
                n=inbits(6);
                if (n<4) {
                        nzeros=48+8*n;
                        nzeros--; return 0;
                }
                return -n;
        }
        n=inbits(6);
        if (n<4) {
                nzeros=16+8*n;
                nzeros--; return 0;
        }
        return n;
}

void showimage (char *pfile,int ox,int oy)
{
	int i,is,js,j,k,n,nx,ny;
        short subf[64],subo[64];
        unsigned char *p;
        const unsigned char swfr[64]={
        0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,
        48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,
        22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,
        55,62,63};


        if (pfile[0]!='D' || pfile[1]!='C' || pfile[2]!='T' || pfile[3]!=1) {
                //printf("Bad file\n");
                //exit(0);
                return;
        }
        nx=pfile[4];     // n subimages X
        ny=pfile[5];     // n subimages Y

        cmpbuf=&pfile[6];
        cbit=0;

        for (is=0;is<ny;is++) {
           for (js=0;js<nx;js++) {
                for (i=0;i<64;i++) {
                        subf[(js&1)?63-swfr[i]:swfr[i]]=incoef();
                }
                if (is<oy || is>oy+19) continue;
                if (js<ox || js>ox+19) continue;
                subf[53]+=1; // Dithering for 16 colors
                iidct(subf,subo);
                p=&panta[(is-oy)*640+((js-ox)<<2)];
                for (k=i=0;i<8;i++) {
                    for (j=0;j<4;j++) {
                        n=subo[k++]+128;
                        if (n<0) n=0; if (n>255) n=255;
                        *p=n&0xf0;
                        n=subo[k++]+128;
                        if (n<0) n=0; if (n>255) n=255;
                        *p|=n>>4;
                        *p++^=0xff;
                    }
                    p=&p[76];
                }
           }
        }
}

main(int argc,char **argv)
{
        int i,fd;
        unsigned char *buf;

        if ((fd=open(argv[1],O_RDONLY))==-1) exit(0);
        i=lseek(fd,0,SEEK_END);
        lseek(fd,0,SEEK_SET);
        if ((buf=malloc(i))==NULL) exit(0);
        read(fd,buf,i);
        close(fd);

        x11_init(160,160);

        for(i=0;i<20;i++) {
                showimage(buf,i,0);
                showpanta();
                usleep(100000);
        }
}
