#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "pbm.h"
#include "X11img.h"
void fdct (float * data);
void fidct (float * datai, float *datao);

int bitfd;
unsigned char bitbuf;
int cbit=0;

extern inline void outbit(int b)
{
        bitbuf<<=1;
        if (b) bitbuf++;
        if (++cbit==8) {
                cbit=0;
                write(bitfd,&bitbuf,1);
        }
}

void flushbits()
{
        if (cbit) {
                bitbuf<<=8-cbit;
                write(bitfd,&bitbuf,1);
        }
}

void outbits(int d,int nb)
{
        if (nb<8) d<<=8-nb;
        for (;nb;nb--) {
                outbit(d&0x80);
                d<<=1;
        }
}
int nzeros=0;
void flushzeros()
{
    while (nzeros>=72) {outbits(0xc,4); outbits(3,6); nzeros-=72;}
    while (nzeros>=64) {outbits(0xc,4); outbits(2,6); nzeros-=64;}
    while (nzeros>=56) {outbits(0xc,4); outbits(1,6); nzeros-=56;}
    while (nzeros>=48) {outbits(0xc,4); outbits(0,6); nzeros-=48;}

    while (nzeros>=40) {outbits(0x8,4); outbits(3,6); nzeros-=40;}
    while (nzeros>=32) {outbits(0x8,4); outbits(2,6); nzeros-=32;}
    while (nzeros>=24) {outbits(0x8,4); outbits(1,6); nzeros-=24;}
    while (nzeros>=16) {outbits(0x8,4); outbits(0,6); nzeros-=16;}
    if (nzeros) outbits(0,nzeros);
    nzeros=0;
}

void outcoef(int n)
{

        if (n==0) {nzeros++; return;}
        //if (n==0) {outbit(0); return;}
        if (nzeros) flushzeros();
        if (abs(n)<4){
                outbit(1);
                outbits(n,3);
        } else {
                if (n<0) {
                       outbits(0xc,4);
                       outbits(-n,6);
                } else {
                       outbits(0x8,4);
                       outbits(n,6);
                }
        }
}

#define FMT_BW  0x00
#define FMT_RGB 0x10
#define FMT_YUV 0x20

main(int argc, char **argv)
{
	int i,is,js,j,k,n,tr,nx,ny,X,Y;
        float subf[64],subo[64],r;
        unsigned char subi[64],*img,*dst,*p;
        const unsigned char swfr[64]={
        0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,
        48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,
        22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,
        55,62,63};

        int h[256];

	if (argc<3) {
		printf("Uso: %s <fichero.pgm> <fichero.dct>\n",argv[0]);
		exit(0);
	}


        img=readpgm(argv[1],&X,&Y);
        if ((dst=malloc(X*Y))==NULL) exit(0);
        nx=X>>3; ny=Y>>3;

        if ((bitfd=creat(argv[2],0666))==-1) exit(0);
        subi[0]='D';            // Magic: "DCT"
        subi[1]='C';
        subi[2]='T';
        subi[3]=FMT_BW|1;       // Version: 1
        subi[4]=nx;             // n subimages X
        subi[5]=ny;             // n subimages Y
        write(bitfd,subi,6);    // Write Header

        //x11_view_image(img,X,Y,1);
        for (i=0;i<256;i++) h[i]=0;

        for (is=0;is<ny;is++) {
           for (js=0;js<nx;js++) {
                p=&img[is*8*X+js*8];
                for (i=0;i<8;i++) {
                    for (j=0;j<8;j++) subf[i*8+j]=(p[j]-127.5)*0.5/63.;
                    p=&p[X];
                }
                //dct2d(subi,subf,8,8);
                fdct(subf);
                for (i=0;i<64;i++) {
                     n=subf[(js&1)?63-swfr[i]:swfr[i]];
                     if (n<-63) n=-63; if (n>63) n=63;
                     outcoef(n);
                }

                fidct(subf,subo);
                p=&dst[is*8*X+js*8];
                for (i=0;i<8;i++) {
                    for (j=0;j<8;j++) {
                        n=2.*subo[i*8+j]+127.5;
                        if (n<0) n=0; if (n>255) n=255;
                        p[j]=n;
                    }
                    p=&p[X];
                }
           }
        }
        x11_view_image(dst,X,Y,1,0);
        flushzeros(); flushbits(); close(bitfd);
}
