#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <fcntl.h>

#include "pbm.h"
#include "X11img.h"

void fidct (float * datai, float *datao);

int bitfd;
unsigned char bitbuf;
int cbit=0;

extern inline int inbit()
{
        int i;
        if (cbit==0){
                read(bitfd,&bitbuf,1);
                cbit=8;
        }
        i=bitbuf>>7;
        bitbuf<<=1; cbit--;
        return i;
}

int inbits(int nb)
{
        int i=0;
        for (;nb;nb--) {
                i<<=1;
                if (inbit()) i++;
        }
        return i;
}

int incoef()
{
        int i,n;
        static int nzeros=0;

        if (nzeros) {
                nzeros--;
                return 0;
        }
        n=inbit();
        if (n==0) return n;
        n=inbits(3);
        if(n!=0 && n!=4) {
                if (n<4) return n;
                return n-8;
        }
        if (n==4) {
                n=inbits(6);
                if (n<4) {
                        nzeros=48+8*n;
                        nzeros--; return 0;
                }
                return -n;
        }
        n=inbits(6);
        if (n<4) {
                nzeros=16+8*n;
                //printf("NZ=%d\n",nzeros);
                nzeros--; return 0;
        }
        return n;
}

main(int argc, char **argv)
{
    int i,ixf,is,js,j,k,n,tr,nx,ny,X,Y,z=1;
    float subf[64],subo[64],r;
    unsigned char subi[64],*img,*dst,*p;
    const unsigned char swfr[64]={
    0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,
    48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,
    22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,
    55,62,63};

    if (argc<2) {
        printf("Uso: %s <fichero.dct>\n",argv[0]);
        exit(0);
    }

    printf("\n");
    for (ixf=1;;) {
        cbit=0;
        bitfd=open(argv[ixf],O_RDONLY);
        read(bitfd,subi,6);     // Read header
        if (subi[0]!='D' || subi[1]!='C' || subi[2]!='T' || subi[3]!=1) {
                printf("Bad file\n");
                exit(0);
        }
        nx=subi[4];     // n subimages X
        ny=subi[5];     // n subimages Y

        X=nx<<3; Y=ny<<3;
        printf("\r                                                         ");
        printf("\r%s (%dx%d pixels)",argv[ixf],X,Y);
        fflush(stdout);

        //for (i=0;i<100;i++) printf("%x ",inbits(4));
        //printf("\n"); exit(0);

        if ((dst=malloc(X*Y))==NULL) exit(0);
        //exit(0);
        //x11_view_image(img,X,Y,1);

        for (is=0;is<ny;is++) {
           for (js=0;js<nx;js++) {

                for (i=0;i<64;i++) {
                        subf[(js&1)?63-swfr[i]:swfr[i]]=incoef();
                        //subf[i]=incoef();
                }
                subf[53]+=1.25; // Dithering for 16 colors
                fidct(subf,subo);
                p=&dst[is*8*X+js*8];
                for (i=0;i<8;i++) {
                    for (j=0;j<8;j++) {
                        n=2.*subo[i*8+j]+127.5;
                        if (n<0) n=0; if (n>255) n=255;
                        p[j]=n;
                    }
                    p=&p[X];
                }
           }
        }
        i=x11_view_image(dst,X,Y,1,z);
        switch(i) {
        case 'q':       printf("\n\n"); exit(0);
        case '1':
        case '2':
        case '3':
        case '4':       z=i-'0'; break;
        case 'u':
        case 'l':       if (ixf>1) ixf--; break;
        case 'd':
        case 'r':       if (ixf<argc-1) ixf++; break;
        }
        free(dst);
    }
        //writepgm(img,"t.pgm",X,Y);
}
