/*--------------------------------------------------------------------------
--------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#define  XK_MISCELLANY
#include <X11/keysymdef.h>
#include <string.h>

const char hello[]="image";

char x11_view_image(unsigned char *img,int imgx,int imgy,int bpp,int zoom)
{
    static Display *mydisplay=NULL;
    static Window mywindow;
    static GC mygc;
    XEvent myevent;
    XSizeHints myhint;
    XWMHints mywmhint;
    XImage *xi;
    unsigned short *imgbuf,*ps,*psm;
    unsigned char *p;
    static int myscreen;

    int i,j,k,l,r,g,b,dr,dg,db;
    int done;
    char rc;

    if (!mydisplay) {
        mydisplay = XOpenDisplay("");
        if(mydisplay==NULL) {fprintf(stderr,"\033[2J\033[HCan't connect to %s\n",
	  		    XDisplayName("")); getchar(); return;}
        myscreen = DefaultScreen(mydisplay);
    }
    if(zoom<1) zoom=1;
    if(zoom>4) zoom=4;
    myhint.x=40;myhint.y=0;
    myhint.width=imgx*zoom;myhint.height=imgy*zoom;
    myhint.flags=PPosition|PSize;
    mywmhint.flags=InputHint;
    mywmhint.input=True;

    mywindow=XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay),
	myhint.x,myhint.y,myhint.width,myhint.height,
	5,0,0);
    XSetStandardProperties(mydisplay,mywindow,hello,hello,
    	None,NULL,0,&myhint);
    XSetWMHints(mydisplay,mywindow,&mywmhint);

    mygc=XCreateGC(mydisplay,mywindow,0,0);

    XSelectInput(mydisplay,mywindow,
	ButtonPressMask|KeyPressMask|ExposureMask);

    XMapRaised(mydisplay,mywindow);

    if ((imgbuf=malloc(imgx*imgy*2*zoom*zoom))==NULL) return;

    // Zoom is done with color interpolation
    // First: Interpolation along X axis
    psm=imgbuf;
    for (j=0;j<imgy;j++) {
        p=&img[j*imgx*bpp];
        for (i=0;i<imgx;i++) {
            switch(bpp) {
            case 1:  r=g=b=*p;  // 1 byte/pixel, monochrome
                     dr=dg=db=(p[1]-r)/zoom;
                     p++; break;
            case 2:  ps=(unsigned short *)p; // 2 byte/pixel, color (565)
                     r=((*ps)>>11)<<3;
                     g=(((*ps)>>5)&0x3f)<<2;
                     b=((*ps)&0x1f)<<3;
                     ps++;
                     dr=((((*ps)>>11)<<3)-r)/zoom;
                     dg=(((((*ps)>>5)&0x3f)<<2)-g)/zoom;
                     db=((((*ps)&0x1f)<<3)-b)/zoom;
                     p=&p[2]; break;
            case 3:
            case 4:  r=p[0]; g=p[1]; b=p[2];  // 3 byte/pixel, color
                     dr=(p[bpp]-r)/zoom;
                     dg=(p[bpp+1]-g)/zoom;
                     db=(p[bpp+2]-b)/zoom;
                     p=&p[bpp]; break;
            }
            for(l=0;l<zoom;l++){
                *psm++=((r>>3)<<11)|((g>>2)<<5)|(b>>3);
                r+=dr; g+=dg; b+=db;
            }
        }
        psm=&psm[(zoom-1)*imgx*zoom];
    }

    // Now our image is 2 byte/pixel color (565)
    // Interpolation along Y axis
    if (zoom>1) {
      for (i=0;i<imgx*zoom;i++){
        for (j=0;j<(imgy-1);j++) {
             psm=&imgbuf[i+j*imgx*zoom*zoom];
             r=((*psm)>>11)<<3;
             g=(((*psm)>>5)&0x3f)<<2;
             b=((*psm)&0x1f)<<3;
             ps=&psm[imgx*zoom*zoom];
             dr=((((*ps)>>11)<<3)-r)/zoom;
             dg=(((((*ps)>>5)&0x3f)<<2)-g)/zoom;
             db=((((*ps)&0x1f)<<3)-b)/zoom;
             for (k=1;k<zoom;k++) {
                psm=&psm[imgx*zoom];
                r+=dr; g+=dg; b+=db;
                *psm=((r>>3)<<11)|((g>>2)<<5)|(b>>3);
             }
        }
      }
    }

    xi = XCreateImage(mydisplay,DefaultVisual(mydisplay,DefaultScreen(mydisplay)),
                      16,ZPixmap,0,(char *)imgbuf,imgx*zoom,imgy*zoom,16,imgx*2*zoom);

    for(done=0;done<2;) {
        XPutImage(mydisplay,mywindow,mygc,xi,0,0,0,0,xi->width,xi->height);

        // X11 Events processing

        for(done=0;!done;) {
          XNextEvent(mydisplay,&myevent);
	  switch(myevent.type)
	  {
          case ButtonPress:  // Update time marks
             //mx=myevent.xbutton.x;
             switch(((XButtonEvent*)&myevent)->button){
             case 1:  break;
             case 3:  break;
             }
             done=1; break;
          case Expose:
             done=1; break;
          case KeyPress:
            j=XLookupKeysym((XKeyEvent *)&myevent,0);
	    switch(j) {
            default:
                done=j; break;
            case XK_Up:         // Up
                done='u'; break;
            case XK_Down:       // Down
                done='d'; break;
            case XK_Right:      // Right
                done='r'; break;
            case XK_Left:       // Left
                done='l'; break;
	    }
	    break;
          }
        }
    }

    XFree((char *)xi);
    XFreeGC(mydisplay,mygc);
    XDestroyWindow(mydisplay,mywindow);
    //XCloseDisplay(mydisplay);
    return done;
}
