|void _flash_prg_(long dir, unsigned short dato)
|void _flash_blk_erase_(long dir);

|Estas rutinas se ejecuta en la RAM, en modo supervisor.
|Se apagan las interrupciones mientras dura la programacin de la Flash.
|Se dan permisos de escritura en los Chip-Selects de las flash y luego
|se quitan al terminar.
|El parmetro dir debe ser una direccin par.

	.data			|Este cdigo se ejecuta desde la RAM
	.globl _flash_prg_
	.globl _flash_blk_erase_

|Trama de pila:
| SP+26	par. dato
| SP+22	par. dir
| SP+18	PC
| SP+2	d0,d1,a0,a1
| SP+0	sr

	.even
_flash_prg_:
	movm.l	%d0-%d1/%a0-%a1,-(%sp)
	move.w  %sr,-(%sp)
	move.w  #0x2700,%sr		|INT off
	bclr.b	#7,0xfffff110		|Flash OS RW
	bclr.b	#7,0xfffff116		|Flash APP RW
	move.l	22(%sp),%d0		|dir
	move.l	%d0,%a1
	andi.l	#0xfff00000,%d0		|Base de la flash
	move.l	%d0,%a0
	move.w	#0xaaaa,0xaaa(%a0)	|Comando Program
	move.w	#0x5555,0x554(%a0)
	move.w	#0xa0a0,0xaaa(%a0)
	move.l	26(%sp),%d0
	move.w	%d0,(%a1)		|Programacion
1:	move.b  1(%a1),%d1		|Esperamos D7_Flash == D7_dato
	eor.b	%d0,%d1
	bmi	1b
        move.w  #0xf0f0,(%a0)		|Comando reset
	bset.b	#7,0xfffff110		|Flash OS RO
	bset.b	#7,0xfffff116		|Flash APP RO
	move.w  (%sp)+,%sr
	movm.l	(%sp)+,%d0-%d1/%a0-%a1
	rts


|Trama de pila:
| SP+18	par. dir
| SP+14	PC
| SP+2	d0,a0,a1
| SP+0	sr

	.even
_flash_blk_erase_:
	movm.l	%d0/%a0-%a1,-(%sp)
	move.w  %sr,-(%sp)
	move.w  #0x2700,%sr		|INT off
	bclr.b	#7,0xfffff110		|Flash OS RW
	bclr.b	#7,0xfffff116		|Flash APP RW
	move.l	18(%sp),%d0		|dir
	move.l	%d0,%a1
	andi.l	#0xfff00000,%d0		|Base de la flash
	move.l	%d0,%a0
	move.w	#0xaaaa,0xaaa(%a0)	|Comando Block ERASE
	move.w	#0x5555,0x554(%a0)
	move.w	#0x8080,0xaaa(%a0)
	move.w	#0xaaaa,0xaaa(%a0)
	move.w	#0x5555,0x554(%a0)
	move.w	#0x3030,(%a1)

1:	cmpi.b	#0xff,1(%a1)		|Esperamos final del borrado
	bne	1b

	move.w  #0xf0f0,(%a0)		|Comando reset
	bset.b	#7,0xfffff110		|Flash OS RO
	bset.b	#7,0xfffff116		|Flash APP RO
	move.w  (%sp)+,%sr
	movm.l	(%sp)+,%d0/%a0-%a1
	rts
